/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.impl.ClipContextImpl;
import com.apple.library.uikit.UIColor;
import java.nio.FloatBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderSystem;
import moe.plushie.armourers_workshop.compatibility.extensions.com.mojang.blaze3d.systems.RenderSystem.Fix16;
import moe.plushie.armourers_workshop.core.data.color.PaintColor;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix3f;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class RenderSystem
extends AbstractRenderSystem {
    private static final AtomicInteger extendedMatrixFlags = new AtomicInteger();
    private static final AtomicInteger extendedScissorFlags = new AtomicInteger();
    private static final Storage<OpenMatrix3f> extendedNormalMatrix = new Storage<OpenMatrix3f>(OpenMatrix3f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedTextureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedLightmapTextureMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<OpenMatrix4f> extendedModelViewMatrix = new Storage<OpenMatrix4f>(OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f));
    private static final Storage<PaintColor> extendedTintColor = new Storage<PaintColor>(PaintColor.WHITE);
    private static final FloatBuffer BUFFER = ObjectUtils.createFloatBuffer(3);

    public static void call(Runnable task) {
        if (RenderSystem.isOnRenderThread()) {
            task.run();
        } else {
            RenderSystem.recordRenderCall(task::run);
        }
    }

    public static int getPixelColor(float x, float y) {
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        double guiScale = window.func_198100_s();
        int sx = (int)((double)x * guiScale);
        int sy = (int)((double)((float)window.func_198087_p() - y) * guiScale);
        BUFFER.rewind();
        GL11.glReadPixels((int)sx, (int)sy, (int)1, (int)1, (int)6407, (int)5126, (FloatBuffer)BUFFER);
        GL11.glFinish();
        int r = Math.round(BUFFER.get() * 255.0f);
        int g = Math.round(BUFFER.get() * 255.0f);
        int b = Math.round(BUFFER.get() * 255.0f);
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public static void addClipRect(int x, int y, int width, int height) {
        ClipContextImpl.getInstance().addClip(new ClipContextImpl.Rectangle(new CGRect(x, y, width, height)));
    }

    public static void removeClipRect() {
        ClipContextImpl.getInstance().removeClip();
    }

    public static void setShaderColor(UIColor color) {
        Fix16.setShaderColor(RenderSystem.class, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    public static void setShaderColor(PaintColor color) {
        Fix16.setShaderColor(RenderSystem.class, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
    }

    public static void setShaderColor(float f, float g, float h) {
        Fix16.setShaderColor(RenderSystem.class, f, g, h, 1.0f);
    }

    public static OpenMatrix3f getExtendedNormalMatrix() {
        return extendedNormalMatrix.get();
    }

    public static void setExtendedNormalMatrix(OpenMatrix3f value) {
        extendedNormalMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedTextureMatrix() {
        return extendedTextureMatrix.get();
    }

    public static void setExtendedTextureMatrix(OpenMatrix4f value) {
        extendedTextureMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedLightmapTextureMatrix() {
        return extendedLightmapTextureMatrix.get();
    }

    public static void setExtendedLightmapTextureMatrix(OpenMatrix4f value) {
        extendedLightmapTextureMatrix.set(value);
    }

    public static OpenMatrix4f getExtendedModelViewMatrix() {
        return extendedModelViewMatrix.get();
    }

    public static void setExtendedModelViewMatrix(OpenMatrix4f value) {
        extendedModelViewMatrix.set(value);
    }

    public static void setExtendedMatrixFlags(int options) {
        extendedMatrixFlags.set(options);
    }

    public static int getExtendedMatrixFlags() {
        return extendedMatrixFlags.get();
    }

    public static void setExtendedScissorFlags(int flags) {
        extendedScissorFlags.set(flags);
    }

    public static int getExtendedScissorFlags() {
        return extendedScissorFlags.get();
    }

    public static void setExtendedTintColor(PaintColor tintColor) {
        extendedTintColor.set(tintColor);
    }

    public static PaintColor getExtendedTintColor() {
        return extendedTintColor.get();
    }

    public static void backupExtendedMatrix() {
        extendedTextureMatrix.save();
        extendedNormalMatrix.save();
        extendedLightmapTextureMatrix.save();
        extendedModelViewMatrix.save();
        extendedTintColor.save();
    }

    public static void restoreExtendedMatrix() {
        extendedTextureMatrix.load();
        extendedNormalMatrix.load();
        extendedLightmapTextureMatrix.load();
        extendedModelViewMatrix.load();
        extendedTintColor.load();
    }

    public static class Storage<T> {
        private T value;
        private T backup;

        public Storage(T value) {
            this.value = value;
            this.backup = value;
        }

        public void save() {
            this.backup = this.value;
        }

        public void load() {
            this.value = this.backup;
        }

        public void set(T value) {
            if (!com.mojang.blaze3d.systems.RenderSystem.isOnRenderThread()) {
                com.mojang.blaze3d.systems.RenderSystem.recordRenderCall(() -> {
                    this.value = value;
                });
            } else {
                this.value = value;
            }
        }

        public T get() {
            Fix16.assertOnRenderThread(Storage.class);
            return this.value;
        }
    }
}

