/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moe.plushie.armourers_workshop.api.skin.ISkinFileHeader;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.exception.InvalidCubeTypeException;
import moe.plushie.armourers_workshop.core.skin.exception.NewerFileVersionException;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinSerializer;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.SkinFileUtils;
import moe.plushie.armourers_workshop.utils.StreamUtils;
import org.jetbrains.annotations.Nullable;

public final class SkinFileStreamUtils {
    public static Skin loadSkinFromFile(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            Skin skin = SkinFileStreamUtils.loadSkinFromStream2(fis);
            fis.close();
            return skin;
        }
        catch (FileNotFoundException e) {
            ModLog.warn("skin file not found.", new Object[0]);
            e.printStackTrace();
        }
        catch (Exception e) {
            ModLog.error("skin file load failed.", new Object[0]);
            e.printStackTrace();
        }
        return null;
    }

    public static boolean saveSkinToFile(File file, Skin skin) {
        ModLog.debug("save skin into '{}'", file);
        try {
            SkinFileUtils.forceMkdirParent(file);
            if (file.exists()) {
                SkinFileUtils.deleteQuietly(file);
            }
            FileOutputStream fos = new FileOutputStream(file);
            SkinFileStreamUtils.saveSkinToStream(fos, skin);
            fos.close();
        }
        catch (FileNotFoundException e) {
            ModLog.warn("skin file not found.", new Object[0]);
            e.printStackTrace();
            return false;
        }
        catch (Exception e) {
            ModLog.error("skin file save failed.", new Object[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean saveSkinToStream(OutputStream outputStream, Skin skin) {
        try (BufferedOutputStream bos = new BufferedOutputStream(outputStream);
             DataOutputStream dos = new DataOutputStream(bos);){
            SkinSerializer.writeToStream(skin, dos);
            dos.flush();
            bos.flush();
        }
        catch (Exception e) {
            ModLog.error("Skin file save failed.", new Object[0]);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Skin loadSkinFromStream(InputStream inputStream) {
        Skin skin = null;
        try {
            skin = SkinFileStreamUtils.loadSkinFromStream2(inputStream);
        }
        catch (IOException e) {
            ModLog.error("Skin file load failed.", new Object[0]);
            e.printStackTrace();
        }
        catch (NewerFileVersionException e) {
            ModLog.error("Can not load skin file it was saved in newer version.", new Object[0]);
            e.printStackTrace();
        }
        catch (InvalidCubeTypeException e) {
            ModLog.error("Unable to load skin. Unknown cube types found.", new Object[0]);
            e.printStackTrace();
        }
        catch (Exception e) {
            ModLog.error("Unable to load skin. Unknown error.", new Object[0]);
            e.printStackTrace();
        }
        return skin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Skin loadSkinFromStream2(InputStream inputStream) throws Exception {
        if (inputStream == null) {
            return null;
        }
        Skin skin = null;
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        DataInputStream dis = new DataInputStream(bis);
        try {
            skin = SkinSerializer.readSkinFromStream(dis);
        }
        catch (Throwable throwable) {
            StreamUtils.closeQuietly(dis, bis);
            throw throwable;
        }
        StreamUtils.closeQuietly(dis, bis);
        return skin;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static ISkinFileHeader readHeaderFromFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String makeFileNameValid(String fileName) {
        fileName = fileName.replaceAll("[<>:\"/\\\\|?*]", "_");
        return fileName;
    }
}

