/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.action.ICanOverride;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ABI;
import moe.plushie.armourers_workshop.core.capability.SkinWardrobe;
import moe.plushie.armourers_workshop.core.data.slot.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.SkinFileStreamUtils;
import moe.plushie.armourers_workshop.utils.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.entity.projectile.TridentEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.GameRules;

public final class SkinUtils {
    private static final float[][][] FACE_UVS = new float[][][]{new float[][]{{1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}}};
    private static final float[][][] FACE_UVS_90 = SkinUtils.reorder(FACE_UVS, 3, 0, 1, 2);
    private static final float[][][] FACE_UVS_180 = SkinUtils.reorder(FACE_UVS, 2, 3, 0, 1);
    private static final float[][][] FACE_UVS_270 = SkinUtils.reorder(FACE_UVS, 1, 2, 3, 0);
    private static final float[][][] FACE_VERTEXES = new float[][][]{new float[][]{{1.0f, 1.0f, 1.0f}, {1.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {1.0f, 0.0f, 1.0f}, {0.0f, -1.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 0.0f, 0.0f}, {0.0f, 0.0f, -1.0f}}, new float[][]{{1.0f, 0.0f, 1.0f}, {1.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 1.0f}, {0.0f, 0.0f, 1.0f}}, new float[][]{{1.0f, 0.0f, 0.0f}, {1.0f, 1.0f, 0.0f}, {1.0f, 1.0f, 1.0f}, {1.0f, 0.0f, 1.0f}, {1.0f, 0.0f, 0.0f}}, new float[][]{{0.0f, 0.0f, 1.0f}, {0.0f, 1.0f, 1.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 0.0f}, {-1.0f, 0.0f, 0.0f}}};

    public static float[][] getRenderUVs(Direction direction, int rot) {
        switch (rot) {
            case 90: {
                return FACE_UVS_90[direction.func_176745_a()];
            }
            case 180: {
                return FACE_UVS_180[direction.func_176745_a()];
            }
            case 270: {
                return FACE_UVS_270[direction.func_176745_a()];
            }
        }
        return FACE_UVS[direction.func_176745_a()];
    }

    public static float[][] getRenderUVs(Direction direction) {
        return FACE_UVS[direction.func_176745_a()];
    }

    public static float[][] getRenderVertexes(Direction direction) {
        return FACE_VERTEXES[direction.func_176745_a()];
    }

    public static Collection<String> getItemOverrides(ISkinPartType partType) {
        ICanOverride override = ObjectUtils.safeCast(partType, ICanOverride.class);
        if (override != null) {
            return override.getItemOverrides();
        }
        return Collections.emptyList();
    }

    public static boolean shouldKeepWardrobe(PlayerEntity entity) {
        if (entity.func_175149_v()) {
            return true;
        }
        int keep = ModConfig.Common.prefersWardrobeDropOnDeath;
        if (keep == 1) {
            return true;
        }
        if (keep == 2) {
            return false;
        }
        return PropertyProvider.getLevel((Entity)entity).func_82736_K().func_223586_b(GameRules.field_223600_c);
    }

    public static void dropAll(PlayerEntity player) {
        if (SkinUtils.shouldKeepWardrobe(player)) {
            return;
        }
        SkinWardrobe oldWardrobe = SkinWardrobe.of((Entity)player);
        if (oldWardrobe != null) {
            oldWardrobe.dropAll(arg_0 -> ((PlayerEntity)player).func_199701_a_(arg_0));
        }
    }

    public static void saveVehicleSkin(Entity entity, ItemStack itemStack) {
        ItemStack itemStack1;
        SkinDescriptor descriptor;
        if (!(entity instanceof BoatEntity) && !(entity instanceof AbstractMinecartEntity)) {
            return;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null && !(descriptor = SkinDescriptor.of(itemStack1 = wardrobe.getItem(SkinSlotType.UNKNOWN, 0))).isEmpty()) {
            SkinDescriptor.setDescriptor(itemStack, descriptor);
        }
    }

    public static void copyVehicleSkin(Entity entity, CompoundNBT tag) {
        if (!(entity instanceof BoatEntity) && !(entity instanceof AbstractMinecartEntity)) {
            return;
        }
        if (tag == null || !tag.func_150297_b("ArmourersWorkshop", 10)) {
            return;
        }
        SkinDescriptor descriptor = new SkinDescriptor(tag.func_74775_l("ArmourersWorkshop"));
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            wardrobe.setItem(SkinSlotType.UNKNOWN, 0, descriptor.asItemStack());
            wardrobe.broadcast();
        }
    }

    public static void copySkinFromOwner(Entity entity) {
        ProjectileEntity projectile = ObjectUtils.safeCast(entity, ProjectileEntity.class);
        if (projectile == null) {
            return;
        }
        Entity owner = projectile.func_234616_v_();
        if (entity instanceof TridentEntity) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.TRIDENT, 0, SkinSlotType.UNKNOWN, 0);
            return;
        }
        if (entity instanceof AbstractArrowEntity) {
            SkinUtils.copySkin(owner, entity, SkinSlotType.BOW, 0, SkinSlotType.UNKNOWN, 0);
            return;
        }
        if (entity instanceof FishingBobberEntity && owner instanceof LivingEntity) {
            ItemStack itemStack = ((LivingEntity)owner).func_184614_ca();
            if (!ABI.is(itemStack, Items.field_151112_aM)) {
                itemStack = ((LivingEntity)owner).func_184592_cb();
            }
            SkinUtils.copySkin(entity, itemStack, SkinSlotType.UNKNOWN, 0);
            return;
        }
    }

    public static void copySkin(Entity src, Entity dest, SkinSlotType fromSlotType, int fromIndex, SkinSlotType toSlotType, int toIndex) {
        ItemStack itemStack = SkinUtils.getSkin(src, fromSlotType, fromIndex);
        if (itemStack.func_190926_b()) {
            return;
        }
        SkinUtils.copySkin(dest, itemStack, toSlotType, toIndex);
    }

    public static void copySkin(Entity dest, ItemStack itemStack, SkinSlotType toSlotType, int toIndex) {
        SkinWardrobe wardrobe = SkinWardrobe.of(dest);
        if (wardrobe != null) {
            wardrobe.setItem(toSlotType, toIndex, itemStack.func_77946_l());
            wardrobe.broadcast();
        }
    }

    public static Skin copySkin(Skin skin) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SkinFileStreamUtils.saveSkinToStream(outputStream, skin);
        byte[] skinData = outputStream.toByteArray();
        Skin skinCopy = SkinFileStreamUtils.loadSkinFromStream(new ByteArrayInputStream(skinData));
        return skinCopy;
    }

    public static ItemStack getSkin(Entity entity, SkinSlotType slotType, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (entity instanceof LivingEntity) {
            itemStack = SkinUtils.getUsingItem((LivingEntity)entity);
        }
        SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
        if (Objects.equals(slotType.getSkinType(), descriptor.getType())) {
            return itemStack;
        }
        SkinWardrobe wardrobe = SkinWardrobe.of(entity);
        if (wardrobe != null) {
            ItemStack itemStack1 = wardrobe.getItem(slotType, index);
            descriptor = SkinDescriptor.of(itemStack1);
            if (Objects.equals(slotType.getSkinType(), descriptor.getType())) {
                return itemStack1;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getUsingItem(LivingEntity entity) {
        ItemStack itemStack = entity.func_184607_cu();
        if (!itemStack.func_190926_b()) {
            return itemStack;
        }
        itemStack = entity.func_184614_ca();
        if (ABI.is(itemStack, Items.field_222114_py) && CrossbowItem.func_220012_d((ItemStack)itemStack)) {
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    private static int getSkinIndex(String partIndexProp, Skin skin, int partIndex) {
        String[] split = partIndexProp.split(":");
        for (int i = 0; i < split.length; ++i) {
            int count = Integer.parseInt(split[i]);
            if (partIndex >= count) continue;
            return i;
        }
        return -1;
    }

    public static VoxelShape apply(VoxelShape shape, OpenMatrix4f matrix) {
        float minX = (float)shape.func_197762_b(Direction.Axis.X);
        float minY = (float)shape.func_197762_b(Direction.Axis.Y);
        float minZ = (float)shape.func_197762_b(Direction.Axis.Z);
        float maxX = (float)shape.func_197758_c(Direction.Axis.X);
        float maxY = (float)shape.func_197758_c(Direction.Axis.Y);
        float maxZ = (float)shape.func_197758_c(Direction.Axis.Z);
        Vector4f[] points = new Vector4f[]{new Vector4f(minX, minY, minZ, 1.0f), new Vector4f(maxX, minY, minZ, 1.0f), new Vector4f(maxX, maxY, minZ, 1.0f), new Vector4f(minX, maxY, minZ, 1.0f), new Vector4f(minX, minY, maxZ, 1.0f), new Vector4f(maxX, minY, maxZ, 1.0f), new Vector4f(maxX, maxY, maxZ, 1.0f), new Vector4f(minX, maxY, maxZ, 1.0f)};
        boolean isReset = false;
        for (Vector4f point : points) {
            point.transform(matrix);
            if (isReset) {
                minX = Math.min(minX, point.x());
                minY = Math.min(minY, point.y());
                minZ = Math.min(minZ, point.z());
                maxX = Math.max(maxX, point.x());
                maxY = Math.max(maxY, point.y());
                maxZ = Math.max(maxZ, point.z());
                continue;
            }
            minX = point.x();
            minY = point.y();
            minZ = point.z();
            maxX = point.x();
            maxY = point.y();
            maxZ = point.z();
            isReset = true;
        }
        return VoxelShapes.func_197873_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    private static float[][][] reorder(float[][][] values, int ... indexes) {
        float[][][] newValues = new float[values.length][][];
        for (int i = 0; i < values.length; ++i) {
            float[][] faces = values[i];
            float[][] newFaces = new float[faces.length][];
            for (int j = 0; j < faces.length; ++j) {
                if (j < indexes.length) {
                    newFaces[indexes[j]] = faces[j];
                    continue;
                }
                newFaces[j] = faces[j];
            }
            newValues[i] = newFaces;
        }
        return newValues;
    }
}

