/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils;

import java.util.ArrayList;
import moe.plushie.armourers_workshop.api.skin.ISkinPaintType;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.api.skin.ISkinType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.core.data.slot.ItemOverrideType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.document.SkinDocumentType;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.utils.TextFormatter;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public final class TranslateUtils {
    private static final TextFormatter FORMATTER = new TextFormatter();

    public static IFormattableTextComponent formatted(String content) {
        return TranslatableProvider.literal(ITextComponent.class, FORMATTER.getFormattedString(content));
    }

    public static IFormattableTextComponent title(String key, Object ... args) {
        return TranslatableProvider.translatable(ITextComponent.class, FORMATTER, key, args);
    }

    public static IFormattableTextComponent subtitle(String key, Object ... args) {
        return TranslateUtils.title(key, args).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY));
    }

    public static ArrayList<ITextComponent> subtitles(String key) {
        ArrayList<ITextComponent> results = new ArrayList<ITextComponent>();
        IFormattableTextComponent value1 = TranslateUtils.subtitle(key, new Object[0]);
        String value = value1.getString();
        if (key.equals(value)) {
            return results;
        }
        Style style = Style.field_240709_b_.func_240712_a_(TextFormatting.GRAY);
        for (String line : FORMATTER.getFormattedString(value).split("(\\r?\\n)|(%n)")) {
            results.add((ITextComponent)TranslatableProvider.literal(ITextComponent.class, line).func_230530_a_(style));
        }
        return results;
    }

    public static class Name {
        public static IFormattableTextComponent of(ItemOverrideType overrideType) {
            return TranslateUtils.title("itemOverrideType.armourers_workshop." + overrideType.getName(), new Object[0]);
        }

        public static IFormattableTextComponent of(SkinDocumentType documentType) {
            IFormattableTextComponent lhs = TranslateUtils.title("documentType.armourers_workshop.category." + documentType.getName(), new Object[0]);
            IFormattableTextComponent rhs = Name.of(documentType.getSkinType());
            return TranslateUtils.title("documentType.armourers_workshop.category", lhs, rhs);
        }

        public static IFormattableTextComponent of(ISkinType skinType) {
            if (skinType == SkinTypes.UNKNOWN) {
                return TranslateUtils.title("skinType.armourers_workshop.all", new Object[0]);
            }
            String path = skinType.getRegistryName().func_110623_a();
            return TranslateUtils.title("skinType.armourers_workshop." + path, new Object[0]);
        }

        public static IFormattableTextComponent of(ISkinPartType skinPartType) {
            String path = skinPartType.getRegistryName().func_110623_a();
            String key = "skinPartType.armourers_workshop." + path;
            IFormattableTextComponent text = TranslateUtils.title(key, new Object[0]);
            if (!text.getString().equals(key)) {
                return text;
            }
            ModLog.debug("missing translation text for key {}", key);
            return TranslateUtils.title("skinPartType.armourers_workshop.all.base", new Object[0]);
        }

        public static IFormattableTextComponent of(ISkinPaintType paintType) {
            String path = paintType.getRegistryName().func_110623_a();
            return TranslateUtils.title("paintType.armourers_workshop." + path, new Object[0]);
        }
    }
}

