/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.utils.math.Vector3f;

public class OpenRay {
    public Vector3f origin;
    public Vector3f direction;

    public OpenRay(Vector3f origin, Vector3f direction) {
        this.origin = origin;
        this.direction = direction;
    }

    public boolean intersects(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        float ix = 1.0f / this.direction.getX();
        float iy = 1.0f / this.direction.getY();
        float iz = 1.0f / this.direction.getZ();
        float t1 = (minX - this.origin.getX()) * ix;
        float t2 = (maxX - this.origin.getX()) * ix;
        float t3 = (minY - this.origin.getY()) * iy;
        float t4 = (maxY - this.origin.getY()) * iy;
        float t5 = (minZ - this.origin.getZ()) * iz;
        float t6 = (maxZ - this.origin.getZ()) * iz;
        float tmin = Math.max(Math.max(Math.min(t1, t2), Math.min(t3, t4)), Math.min(t5, t6));
        float tmax = Math.min(Math.min(Math.max(t1, t2), Math.max(t3, t4)), Math.max(t5, t6));
        return tmax >= 0.0f && tmax >= tmin;
    }

    public void transform(IMatrix4f matrix) {
        float[] v1 = new float[]{this.origin.getX(), this.origin.getY(), this.origin.getZ(), 1.0f};
        float[] v2 = new float[]{this.direction.getX(), this.direction.getY(), this.direction.getZ(), 0.0f};
        matrix.multiply(v1);
        matrix.multiply(v2);
        this.origin = new Vector3f(v1);
        this.direction = new Vector3f(v2);
    }

    public OpenRay transforming(IMatrix4f matrix) {
        OpenRay ret = this.copy();
        ret.transform(matrix);
        return ret;
    }

    public OpenRay copy() {
        return new OpenRay(this.origin, this.direction);
    }
}

