/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.api.math.IRectangle3f;
import moe.plushie.armourers_workshop.utils.ObjectUtils;
import moe.plushie.armourers_workshop.utils.math.OpenBoundingBox;
import moe.plushie.armourers_workshop.utils.math.Rectangle3f;
import moe.plushie.armourers_workshop.utils.math.Vector4f;

public class OpenVoxelShape
implements Iterable<Vector4f> {
    private OpenBoundingBox aabb;
    private Rectangle3f box;
    private ArrayList<Vector4f> vertexes;

    public static OpenVoxelShape empty() {
        return new OpenVoxelShape();
    }

    public static OpenVoxelShape box(IRectangle3f bounds) {
        Rectangle3f rect = ObjectUtils.safeCast(bounds, Rectangle3f.class);
        if (rect != null) {
            return OpenVoxelShape.box(rect);
        }
        return OpenVoxelShape.box(new Rectangle3f(bounds));
    }

    public static OpenVoxelShape box(Rectangle3f bounds) {
        OpenVoxelShape shape = new OpenVoxelShape();
        shape.box = bounds;
        return shape;
    }

    public OpenBoundingBox aabb() {
        if (this.aabb != null) {
            return this.aabb;
        }
        this.aabb = new OpenBoundingBox(this.bounds());
        return this.aabb;
    }

    public Rectangle3f bounds() {
        if (this.box != null) {
            return this.box;
        }
        if (this.vertexes == null || this.vertexes.size() == 0) {
            return Rectangle3f.ZERO;
        }
        Iterator<Vector4f> iterator = this.vertexes.iterator();
        Vector4f fp = iterator.next();
        float minX = fp.x();
        float minY = fp.y();
        float minZ = fp.z();
        float maxX = fp.x();
        float maxY = fp.y();
        float maxZ = fp.z();
        while (iterator.hasNext()) {
            Vector4f point = iterator.next();
            minX = Math.min(minX, point.x());
            minY = Math.min(minY, point.y());
            minZ = Math.min(minZ, point.z());
            maxX = Math.max(maxX, point.x());
            maxY = Math.max(maxY, point.y());
            maxZ = Math.max(maxZ, point.z());
        }
        this.box = new Rectangle3f(minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ);
        return this.box;
    }

    public void mul(IMatrix4f matrix) {
        for (Vector4f vector : this.getVertexes()) {
            vector.transform(matrix);
        }
        this.box = null;
        this.aabb = null;
    }

    public void add(float x, float y, float z, float width, float height, float depth) {
        List<Vector4f> list = this.getVertexes();
        list.add(new Vector4f(x, y, z, 1.0f));
        list.add(new Vector4f(x + width, y, z, 1.0f));
        list.add(new Vector4f(x + width, y + height, z, 1.0f));
        list.add(new Vector4f(x, y + height, z, 1.0f));
        list.add(new Vector4f(x, y, z + depth, 1.0f));
        list.add(new Vector4f(x + width, y, z + depth, 1.0f));
        list.add(new Vector4f(x + width, y + height, z + depth, 1.0f));
        list.add(new Vector4f(x, y + height, z + depth, 1.0f));
        this.box = null;
        this.aabb = null;
    }

    public void add(OpenVoxelShape shape1) {
        List<Vector4f> list = this.getVertexes();
        list.addAll(shape1.getVertexes());
        this.box = null;
    }

    public void add(IRectangle3f rect) {
        this.add(rect.getX(), rect.getY(), rect.getZ(), rect.getWidth(), rect.getHeight(), rect.getDepth());
    }

    public void optimize() {
        if (this.vertexes == null || this.vertexes.size() <= 8) {
            return;
        }
        List<Vector4f> list = this.getVertexes();
        HashSet<Vector4f> addVertexes = new HashSet<Vector4f>(list.size());
        HashSet<Vector4f> uniquesVertexes = new HashSet<Vector4f>(list.size());
        for (Vector4f vector : list) {
            if (addVertexes.contains(vector)) {
                uniquesVertexes.remove(vector);
                continue;
            }
            addVertexes.add(vector);
            uniquesVertexes.add(vector);
        }
        this.vertexes = Lists.newArrayList(uniquesVertexes);
    }

    public OpenVoxelShape copy() {
        OpenVoxelShape shape = new OpenVoxelShape();
        shape.box = this.box;
        shape.aabb = this.aabb;
        if (this.vertexes != null) {
            ArrayList<Vector4f> newVertexes = new ArrayList<Vector4f>();
            newVertexes.ensureCapacity(this.vertexes.size());
            for (Vector4f vector : this.vertexes) {
                newVertexes.add(vector.copy());
            }
            shape.vertexes = newVertexes;
        }
        return shape;
    }

    @Override
    public Iterator<Vector4f> iterator() {
        if (this.vertexes != null) {
            return this.vertexes.iterator();
        }
        return this.getVertexes(this.box).iterator();
    }

    private List<Vector4f> getVertexes() {
        if (this.vertexes == null) {
            this.vertexes = this.getVertexes(this.box);
        }
        return this.vertexes;
    }

    private ArrayList<Vector4f> getVertexes(IRectangle3f box) {
        if (box == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new Vector4f[]{new Vector4f(box.getMinX(), box.getMinY(), box.getMinZ(), 1.0f), new Vector4f(box.getMaxX(), box.getMinY(), box.getMinZ(), 1.0f), new Vector4f(box.getMaxX(), box.getMaxY(), box.getMinZ(), 1.0f), new Vector4f(box.getMinX(), box.getMaxY(), box.getMinZ(), 1.0f), new Vector4f(box.getMinX(), box.getMinY(), box.getMaxZ(), 1.0f), new Vector4f(box.getMaxX(), box.getMinY(), box.getMaxZ(), 1.0f), new Vector4f(box.getMaxX(), box.getMaxY(), box.getMaxZ(), 1.0f), new Vector4f(box.getMinX(), box.getMaxY(), box.getMaxZ(), 1.0f)});
    }
}

