/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.math;

import moe.plushie.armourers_workshop.api.math.IMatrix4f;
import moe.plushie.armourers_workshop.utils.MathUtils;
import moe.plushie.armourers_workshop.utils.math.OpenQuaternionf;
import net.minecraft.dispenser.IPosition;

public class Vector4f {
    public static final Vector4f ZERO = new Vector4f(0.0f, 0.0f, 0.0f, 0.0f);
    private float x;
    private float y;
    private float z;
    private float w;

    public Vector4f() {
    }

    public Vector4f(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public Vector4f(Vector4f pos) {
        this(pos.x, pos.y, pos.z, pos.w);
    }

    public Vector4f(IPosition pos) {
        this((float)pos.func_82615_a(), (float)pos.func_82617_b(), (float)pos.func_82616_c(), 1.0f);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector4f)) {
            return false;
        }
        Vector4f vector4f = (Vector4f)other;
        if (Float.compare(vector4f.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(vector4f.y, this.y) != 0) {
            return false;
        }
        if (Float.compare(vector4f.z, this.z) != 0) {
            return false;
        }
        return Float.compare(vector4f.w, this.w) == 0;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.x);
        i = 31 * i + Float.floatToIntBits(this.y);
        i = 31 * i + Float.floatToIntBits(this.z);
        return 31 * i + Float.floatToIntBits(this.w);
    }

    public float x() {
        return this.x;
    }

    public float y() {
        return this.y;
    }

    public float z() {
        return this.z;
    }

    public float w() {
        return this.w;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public void setZ(float z) {
        this.z = z;
    }

    public void setW(float w) {
        this.w = w;
    }

    public void set(float x, float y, float z, float w) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.w = w;
    }

    public void add(float tx, float ty, float tz, float tw) {
        this.x += tx;
        this.y += ty;
        this.z += tz;
        this.w += tw;
    }

    public void add(Vector4f pos) {
        this.x += pos.x;
        this.y += pos.y;
        this.z += pos.z;
        this.w += pos.w;
    }

    public void subtract(float tx, float ty, float tz, float tw) {
        this.x -= tx;
        this.y -= ty;
        this.z -= tz;
        this.w += tw;
    }

    public void subtract(Vector4f pos) {
        this.x -= pos.x;
        this.y -= pos.y;
        this.z -= pos.z;
        this.w -= pos.w;
    }

    public void scale(float scale) {
        this.x *= scale;
        this.y *= scale;
        this.z *= scale;
        this.w *= scale;
    }

    public void scale(float sx, float sy, float sz, float sw) {
        this.x *= sx;
        this.y *= sy;
        this.z *= sz;
        this.w *= sw;
    }

    public void scale(Vector4f pos) {
        this.x *= pos.x;
        this.y *= pos.y;
        this.z *= pos.z;
        this.w *= pos.w;
    }

    public void transform(IMatrix4f matrix) {
        float[] floats = new float[]{this.x, this.y, this.z, this.w};
        matrix.multiply(floats);
        this.set(floats[0], floats[1], floats[2], floats[3]);
    }

    public void transform(OpenQuaternionf q) {
        OpenQuaternionf quaternion = new OpenQuaternionf(q);
        quaternion.mul(new OpenQuaternionf(this.x, this.y, this.z, 0.0f));
        OpenQuaternionf quaternion1 = new OpenQuaternionf(q);
        quaternion1.conjugate();
        quaternion.mul(quaternion1);
        this.set(quaternion.x(), quaternion.y(), quaternion.z(), this.w);
    }

    public float dot(Vector4f pos) {
        return this.x * pos.x + this.y * pos.y + this.z * pos.z + this.w * pos.w;
    }

    public boolean normalize() {
        float f = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        if ((double)f < 1.0E-5) {
            return false;
        }
        float f1 = MathUtils.fastInvSqrt(f);
        this.x *= f1;
        this.y *= f1;
        this.z *= f1;
        this.w *= f1;
        return true;
    }

    public Vector4f scaling(float scale) {
        Vector4f ret = this.copy();
        ret.scale(scale);
        return ret;
    }

    public Vector4f scaling(float sx, float sy, float sz, float sw) {
        Vector4f ret = this.copy();
        ret.scale(sx, sy, sz, sw);
        return ret;
    }

    public Vector4f scaling(Vector4f pos) {
        Vector4f ret = this.copy();
        ret.scale(pos);
        return ret;
    }

    public Vector4f adding(float tx, float ty, float tz, float tw) {
        Vector4f ret = this.copy();
        ret.add(tx, ty, tz, tw);
        return ret;
    }

    public Vector4f adding(Vector4f pos) {
        Vector4f ret = this.copy();
        ret.add(pos);
        return ret;
    }

    public Vector4f subtracting(float tx, float ty, float tz, float tw) {
        Vector4f ret = this.copy();
        ret.subtract(tx, ty, tz, tw);
        return ret;
    }

    public Vector4f subtracting(Vector4f pos) {
        Vector4f ret = this.copy();
        ret.subtract(pos);
        return ret;
    }

    public Vector4f transforming(IMatrix4f mat) {
        Vector4f ret = this.copy();
        ret.transform(mat);
        return ret;
    }

    public Vector4f transforming(OpenQuaternionf value) {
        Vector4f ret = this.copy();
        ret.transform(value);
        return ret;
    }

    public Vector4f normalizing() {
        Vector4f ret = this.copy();
        ret.normalize();
        return ret;
    }

    public Vector4f copy() {
        return new Vector4f(this.x, this.y, this.z, this.w);
    }

    public String toString() {
        return String.format("(%g %g %g %g)", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }
}

