/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.texture;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.skin.ISkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.texture.SkyBox;
import net.minecraft.util.Direction;

public class PlayerTextureModel {
    public static final int TEXTURE_OLD_WIDTH = 64;
    public static final int TEXTURE_OLD_HEIGHT = 32;
    public static final int TEXTURE_OLD_SIZE = 2048;
    public static final PlayerTextureModel STAVE_V1 = new PlayerTextureModel(builder -> {
        builder.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new SkyBox(-4, -8, -4, 8, 8, 8, 32, 0));
        builder.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new SkyBox(-4, -8, -4, 8, 8, 8, 0, 0));
        builder.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new SkyBox(-4, 0, -2, 8, 12, 4, 16, 16));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new SkyBox(-2, 0, -2, 4, 12, 4, 0, 16));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new SkyBox(-2, 0, -2, 4, 12, 4, 0, 16, true));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new SkyBox(-3, -2, -2, 4, 12, 4, 40, 16));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new SkyBox(-1, -2, -2, 4, 12, 4, 40, 16, true));
    });
    public static final PlayerTextureModel STAVE_V2 = new PlayerTextureModel(builder -> {
        builder.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new SkyBox(-4, -8, -4, 8, 8, 8, 32, 0));
        builder.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new SkyBox(-4, -8, -4, 8, 8, 8, 0, 0));
        builder.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new SkyBox(-4, 0, -2, 8, 12, 4, 16, 16));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new SkyBox(-2, 0, -2, 4, 12, 4, 0, 16));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new SkyBox(-2, 0, -2, 4, 12, 4, 16, 48));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new SkyBox(-3, -2, -2, 4, 12, 4, 40, 16));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new SkyBox(-1, -2, -2, 4, 12, 4, 32, 48));
    });
    public static final PlayerTextureModel ALEX_V1 = new PlayerTextureModel(builder -> {
        builder.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new SkyBox(-4, -8, -4, 8, 8, 8, 32, 0));
        builder.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new SkyBox(-4, -8, -4, 8, 8, 8, 0, 0));
        builder.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new SkyBox(-4, 0, -2, 8, 12, 4, 16, 16));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new SkyBox(-2, 0, -2, 4, 12, 4, 0, 16));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new SkyBox(-2, 0, -2, 4, 12, 4, 0, 16, true));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new SkyBox(-2, -2, -2, 3, 12, 4, 40, 16));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new SkyBox(-1, -2, -2, 3, 12, 4, 40, 16, true));
    });
    public static final PlayerTextureModel ALEX_V2 = new PlayerTextureModel(builder -> {
        builder.put((Object)SkinPartTypes.BIPPED_HAT, (Object)new SkyBox(-4, -8, -4, 8, 8, 8, 32, 0));
        builder.put((Object)SkinPartTypes.BIPPED_HEAD, (Object)new SkyBox(-4, -8, -4, 8, 8, 8, 0, 0));
        builder.put((Object)SkinPartTypes.BIPPED_CHEST, (Object)new SkyBox(-4, 0, -2, 8, 12, 4, 16, 16));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_THIGH, (Object)new SkyBox(-2, 0, -2, 4, 12, 4, 0, 16));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_THIGH, (Object)new SkyBox(-2, 0, -2, 4, 12, 4, 16, 48));
        builder.put((Object)SkinPartTypes.BIPPED_RIGHT_ARM, (Object)new SkyBox(-2, -2, -2, 3, 12, 4, 40, 16));
        builder.put((Object)SkinPartTypes.BIPPED_LEFT_ARM, (Object)new SkyBox(-1, -2, -2, 3, 12, 4, 32, 48));
    });
    protected final ImmutableMap<ISkinPartType, SkyBox> skyBoxes;

    public PlayerTextureModel(Consumer<ImmutableMap.Builder<ISkinPartType, SkyBox>> consumer) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        consumer.accept((ImmutableMap.Builder<ISkinPartType, SkyBox>)builder);
        this.skyBoxes = builder.build();
    }

    public static PlayerTextureModel of(int width, int height, boolean slim) {
        if (slim) {
            if (height <= 32) {
                return ALEX_V1;
            }
            return ALEX_V2;
        }
        if (height <= 32) {
            return STAVE_V1;
        }
        return STAVE_V2;
    }

    public SkyBox get(ISkinPartType partType) {
        if (partType == SkinPartTypes.BIPPED_LEFT_FOOT) {
            return this.get(SkinPartTypes.BIPPED_LEFT_THIGH);
        }
        if (partType == SkinPartTypes.BIPPED_RIGHT_FOOT) {
            return this.get(SkinPartTypes.BIPPED_RIGHT_THIGH);
        }
        return (SkyBox)this.skyBoxes.get((Object)partType);
    }

    public TexturePos get(ISkinPartType partType, int x, int y, int z, Direction dir) {
        SkyBox box = this.get(partType);
        if (box != null) {
            return box.get(x, y, z, dir);
        }
        return null;
    }

    public void forEach(BiConsumer<ISkinPartType, SkyBox> consumer) {
        this.skyBoxes.forEach(consumer);
    }

    public ImmutableSet<Map.Entry<ISkinPartType, SkyBox>> entrySet() {
        return this.skyBoxes.entrySet();
    }
}

