/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.texture;

import com.apple.library.coregraphics.CGRect;
import java.util.EnumMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import moe.plushie.armourers_workshop.utils.math.Rectangle3i;
import moe.plushie.armourers_workshop.utils.math.TexturePos;
import moe.plushie.armourers_workshop.utils.math.Vector3i;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.Nullable;

public class SkyBox {
    protected final EnumMap<Direction, ToIntFunction<Vector3i>> validator = new EnumMap(Direction.class);
    protected final EnumMap<Direction, Function<Vector3i, TexturePos>> evaluator = new EnumMap(Direction.class);
    protected final Rectangle3i rect;
    protected final CGRect textureRect;
    protected final boolean mirror;

    public SkyBox(int x, int y, int z, int width, int height, int depth, int u, int v) {
        this(x, y, z, width, height, depth, u, v, false);
    }

    public SkyBox(int x, int y, int z, int width, int height, int depth, int u, int v, boolean mirror) {
        this.mirror = mirror;
        this.rect = new Rectangle3i(x, y, z, width, height, depth);
        this.textureRect = new CGRect(u, v, depth + width + depth + width, depth + height);
        this.put(Direction.UP, this.positiveX(u + depth), this.negativeZ(v + depth - 1));
        this.put(Direction.DOWN, this.positiveX(u + depth + width), this.negativeZ(v + depth - 1));
        this.put(Direction.NORTH, this.positiveX(u + depth), this.positiveY(v + depth));
        this.put(Direction.SOUTH, this.negativeX(u + depth + width + depth + width - 1), this.positiveY(v + depth));
        this.put(Direction.WEST, this.positiveZ(u + depth + width), this.positiveY(v + depth));
        this.put(Direction.EAST, this.negativeZ(u + depth - 1), this.positiveY(v + depth));
        this.valid(Direction.UP, this.negativeY(0));
        this.valid(Direction.DOWN, this.negativeY(height - 1));
        this.valid(Direction.NORTH, this.negativeZ(0));
        this.valid(Direction.SOUTH, this.negativeZ(depth - 1));
        this.valid(Direction.WEST, this.negativeX(width - 1));
        this.valid(Direction.EAST, this.negativeX(0));
    }

    protected void valid(Direction dir, ToIntFunction<Vector3i> diff) {
        this.validator.put(this.getMirroredDirection(dir), diff);
    }

    protected void put(Direction dir, ToIntFunction<Vector3i> uf, ToIntFunction<Vector3i> vf) {
        this.evaluator.put(this.getMirroredDirection(dir), pos -> new TexturePos(uf.applyAsInt((Vector3i)pos), vf.applyAsInt((Vector3i)pos)));
    }

    public void forEach(IPixelConsumer consumer) {
        for (Direction dir : Direction.values()) {
            for (int ix = this.rect.getMinX(); ix < this.rect.getMaxX(); ++ix) {
                for (int iy = this.rect.getMinY(); iy < this.rect.getMaxY(); ++iy) {
                    for (int iz = this.rect.getMinZ(); iz < this.rect.getMaxZ(); ++iz) {
                        TexturePos texture = this.get(ix, iy, iz, dir);
                        if (texture == null) continue;
                        consumer.accept(texture, ix, iy, iz, dir);
                    }
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SkyBox)) {
            return false;
        }
        SkyBox skyBox = (SkyBox)o;
        return this.mirror == skyBox.mirror && this.rect.equals(skyBox.rect) && this.textureRect.equals(skyBox.textureRect);
    }

    public int hashCode() {
        return Objects.hash(this.rect, this.textureRect, this.mirror);
    }

    @Nullable
    public TexturePos get(int x, int y, int z, Direction dir) {
        if (this.isInside(x -= this.rect.getX(), y -= this.rect.getY(), z -= this.rect.getZ())) {
            ToIntFunction<Vector3i> predicate = this.validator.get(dir);
            Function<Vector3i, TexturePos> eval = this.evaluator.get(dir);
            Vector3i pos = new Vector3i(x, y, z);
            if (eval != null && predicate.applyAsInt(pos) == 0) {
                return eval.apply(pos);
            }
        }
        return null;
    }

    public Rectangle3i getBounds() {
        return this.rect;
    }

    private boolean isInside(int x, int y, int z) {
        return x >= 0 && x < this.rect.getWidth() && y >= 0 && y < this.rect.getHeight() && z >= 0 && z < this.rect.getDepth();
    }

    private Direction getMirroredDirection(Direction direction) {
        if (this.mirror && direction.func_176740_k() == Direction.Axis.X) {
            return direction.func_176734_d();
        }
        return direction;
    }

    private ToIntFunction<Vector3i> positiveX(int t) {
        if (this.mirror) {
            return pos -> t + (this.rect.getWidth() - pos.getX() - 1);
        }
        return pos -> t + pos.getX();
    }

    private ToIntFunction<Vector3i> positiveY(int t) {
        return pos -> t + pos.getY();
    }

    private ToIntFunction<Vector3i> positiveZ(int t) {
        return pos -> t + pos.getZ();
    }

    private ToIntFunction<Vector3i> negativeX(int t) {
        if (this.mirror) {
            return pos -> t - (this.rect.getWidth() - pos.getX() - 1);
        }
        return pos -> t - pos.getX();
    }

    private ToIntFunction<Vector3i> negativeY(int t) {
        return pos -> t - pos.getY();
    }

    private ToIntFunction<Vector3i> negativeZ(int t) {
        return pos -> t - pos.getZ();
    }

    public static interface IPixelConsumer {
        public void accept(TexturePos var1, int var2, int var3, int var4, Direction var5);
    }
}

