/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.utils.texture;

import java.util.EnumMap;
import moe.plushie.armourers_workshop.api.common.ITextureBox;
import moe.plushie.armourers_workshop.api.common.ITextureKey;
import moe.plushie.armourers_workshop.api.common.ITextureOptions;
import moe.plushie.armourers_workshop.api.common.ITextureProvider;
import moe.plushie.armourers_workshop.utils.math.Rectangle2f;
import moe.plushie.armourers_workshop.utils.math.Vector2f;
import moe.plushie.armourers_workshop.utils.texture.TextureKey;
import net.minecraft.util.Direction;
import org.jetbrains.annotations.Nullable;

public class TextureBox
implements ITextureBox {
    private final Vector2f texturePos;
    private final ITextureProvider defaultTexture;
    private final float width;
    private final float height;
    private final float depth;
    private final boolean mirror;
    private EnumMap<Direction, Rectangle2f> variantRects;
    private EnumMap<Direction, ITextureOptions> variantOptions;
    private EnumMap<Direction, ITextureProvider> variantTextures;

    public TextureBox(float width, float height, float depth, boolean mirror, @Nullable Vector2f baseUV, @Nullable ITextureProvider defaultTexture) {
        this.texturePos = baseUV;
        this.defaultTexture = defaultTexture;
        this.width = width;
        this.height = height;
        this.depth = depth;
        this.mirror = mirror;
    }

    public void putTextureRect(Direction dir, Rectangle2f rect) {
        if (this.variantRects == null) {
            this.variantRects = new EnumMap(Direction.class);
        }
        this.variantRects.put(dir, rect);
    }

    public void putTextureOptions(Direction dir, ITextureOptions options) {
        if (this.variantOptions == null) {
            this.variantOptions = new EnumMap(Direction.class);
        }
        this.variantOptions.put(dir, options);
    }

    public void putTextureProvider(Direction dir, ITextureProvider textureProvider) {
        if (this.variantTextures == null) {
            this.variantTextures = new EnumMap(Direction.class);
        }
        this.variantTextures.put(dir, textureProvider);
    }

    public TextureBox separated() {
        TextureBox box = new TextureBox(this.width, this.height, this.depth, this.mirror, null, this.defaultTexture);
        for (Direction dir : Direction.values()) {
            ITextureKey key = this.getTexture(dir);
            if (key == null) continue;
            box.putTextureRect(dir, new Rectangle2f(key.getU(), key.getV(), key.getWidth(), key.getHeight()));
            if (key.getProvider() == this.defaultTexture) continue;
            box.putTextureProvider(dir, key.getProvider());
        }
        return box;
    }

    @Override
    @Nullable
    public ITextureKey getTexture(Direction dir) {
        if (this.mirror) {
            return this.getMirrorTexture(dir);
        }
        switch (dir) {
            case UP: {
                return this.makeTexture(dir, this.depth, 0.0f, this.width, this.depth);
            }
            case DOWN: {
                return this.makeTexture(dir, this.depth + this.width, 0.0f, this.width, this.depth);
            }
            case NORTH: {
                return this.makeTexture(dir, this.depth, this.depth, this.width, this.height);
            }
            case SOUTH: {
                return this.makeTexture(dir, this.depth + this.width + this.depth, this.depth, this.width, this.height);
            }
            case WEST: {
                return this.makeTexture(dir, this.depth + this.width, this.depth, this.depth, this.height);
            }
            case EAST: {
                return this.makeTexture(dir, 0.0f, this.depth, this.depth, this.height);
            }
        }
        return null;
    }

    private ITextureKey getMirrorTexture(Direction dir) {
        switch (dir) {
            case UP: {
                return this.makeTexture(dir, this.depth + this.width, 0.0f, -this.width, this.depth);
            }
            case DOWN: {
                return this.makeTexture(dir, this.depth + this.width + this.width, 0.0f, -this.width, this.depth);
            }
            case NORTH: {
                return this.makeTexture(dir, this.depth + this.width, this.depth, -this.width, this.height);
            }
            case SOUTH: {
                return this.makeTexture(dir, this.depth + this.width + this.depth + this.width, this.depth, -this.width, this.height);
            }
            case WEST: {
                return this.makeTexture(dir, 0.0f + this.depth, this.depth, -this.depth, this.height);
            }
            case EAST: {
                return this.makeTexture(dir, this.depth + this.width + this.depth, this.depth, -this.depth, this.height);
            }
        }
        return null;
    }

    @Nullable
    private ITextureKey makeTexture(Direction dir, float u, float v, float s, float t) {
        ITextureProvider texture = this.getTextureProvider(dir);
        if (texture == null) {
            return null;
        }
        Rectangle2f rect = this.getTextureRect(dir);
        if (rect != null) {
            ITextureOptions options = this.getTextureOptions(dir);
            return new TextureKey(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight(), options, texture);
        }
        Vector2f pos = this.texturePos;
        if (pos != null) {
            return new Entry(pos.getX() + u, pos.getY() + v, s, t, texture, pos);
        }
        return null;
    }

    @Nullable
    private Rectangle2f getTextureRect(Direction dir) {
        if (this.variantRects != null) {
            return this.variantRects.get(dir);
        }
        return null;
    }

    private ITextureOptions getTextureOptions(Direction dir) {
        if (this.variantOptions != null) {
            return this.variantOptions.get(dir);
        }
        return null;
    }

    private ITextureProvider getTextureProvider(Direction dir) {
        if (this.variantTextures != null) {
            return this.variantTextures.getOrDefault(dir, this.defaultTexture);
        }
        return this.defaultTexture;
    }

    public static class Entry
    extends TextureKey {
        protected final Vector2f parent;

        public Entry(float u, float v, float width, float height, ITextureProvider provider, Vector2f parent) {
            super(u, v, width, height, provider);
            this.parent = parent;
        }

        public Vector2f getParent() {
            return this.parent;
        }
    }
}

