/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import java.lang.ref.WeakReference;
import org.jetbrains.annotations.Nullable;

public class DelegateImpl<T> {
    private final T def;
    private WeakReference<T> ref;

    private DelegateImpl(T def) {
        this.def = def;
    }

    public static <T> DelegateImpl<T> of(T defaultValue) {
        return new DelegateImpl<T>(defaultValue);
    }

    public T invoker() {
        T value = this.get();
        if (value != null) {
            return value;
        }
        return this.def;
    }

    @Nullable
    public T get() {
        if (this.ref != null) {
            return this.ref.get();
        }
        return null;
    }

    public void set(T value) {
        this.ref = value != null ? new WeakReference<T>(value) : null;
    }
}

