/*
 * Decompiled with CFR 0.152.
 */
package com.apple.library.impl;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.foundation.NSRange;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextPosition;
import com.apple.library.foundation.NSTextRange;
import com.apple.library.impl.AppearanceImpl;
import com.apple.library.impl.FormattedStringImpl;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIFont;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextStorageImpl {
    public CGPoint offset = CGPoint.ZERO;
    public int maxLength = 1000;
    public BiConsumer<CGRect, CGSize> sizeDidChange = (c, s) -> {};
    public BiConsumer<String, String> valueDidChange = (o, n) -> {};
    public BiPredicate<NSRange, String> valueShouldChange = (o, n) -> true;
    public Runnable selectionDidChange = () -> {};
    private String value = "";
    private NSString placeholder;
    private UIColor placeholderColor;
    private UIFont font;
    private UIColor textColor;
    private CGSize boundingSize = CGSize.ZERO;
    private NSTextPosition highlightPos = NSTextPosition.ZERO;
    private NSTextPosition cursorPos = NSTextPosition.ZERO;
    private int lineSpacing = 1;
    private boolean isFocused = false;
    private long cursorTimestamp = 0L;
    private CGRect cursorRect = CGRect.ZERO;
    private Collection<CGRect> highlightedRects;
    private UIFont cachedFont;
    private Collection<TextLine> cachedTextLines;

    public void insertText(String inputText) {
        int remaining;
        String oldValue = this.value;
        String replacementText = this.formattedString(inputText);
        NSRange range = this.selectionRange();
        if (!this.valueShouldChange.test(range, replacementText)) {
            return;
        }
        int length = replacementText.length();
        if (this.maxLength > 0 && (remaining = Math.max(this.maxLength - (oldValue.length() - range.length), 0)) < length) {
            replacementText = replacementText.substring(0, remaining);
            length = remaining;
        }
        int startIndex = range.startIndex();
        int endIndex = range.endIndex();
        this.setValue(new StringBuilder(oldValue).replace(startIndex, endIndex, replacementText).toString());
        this.setCursorAndHighlightPos(NSTextPosition.forward(startIndex + length));
        this.valueDidChange.accept(oldValue, this.value);
    }

    public void deleteText(TextTokenizer tokenizer, int count) {
        int endIndex;
        if (this.value.isEmpty()) {
            return;
        }
        if (!this.cursorPos.equals(this.highlightPos)) {
            this.insertText("");
            return;
        }
        int advancedIndex = tokenizer.advance(this.value, this.cursorPos.value, count);
        int startIndex = Math.min(advancedIndex, this.cursorPos.value);
        if (startIndex == (endIndex = Math.max(advancedIndex, this.cursorPos.value))) {
            return;
        }
        String oldValue = this.value;
        if (!this.valueShouldChange.test(NSRange.of(startIndex, endIndex), "")) {
            return;
        }
        this.setValue(new StringBuilder(oldValue).delete(startIndex, endIndex).toString());
        this.setCursorAndHighlightPos(NSTextPosition.forward(startIndex));
        this.valueDidChange.accept(oldValue, this.value);
    }

    private void setCursorPos(NSTextPosition pos) {
        this.cursorPos = this.clamp(pos, this.beginOfDocument(), this.endOfDocument());
        this.cursorTimestamp = System.currentTimeMillis();
        this.setNeedsRemakeTextLine();
    }

    private void setHighlightPos(NSTextPosition pos) {
        this.highlightPos = this.clamp(pos, this.beginOfDocument(), this.endOfDocument());
        this.setNeedsRemakeTextLine();
    }

    public void sizeToFit() {
        this.remakeTextLineIfNeeded(this.boundingSize, this.font());
    }

    public void render(CGPoint point, CGGraphicsContext context) {
        if (this.cachedTextLines == null) {
            this.sizeToFit();
        }
        UIFont font = this.cachedFont;
        int textColor = this.defaultTextColor();
        if (this.cachedFont == null || this.cachedTextLines == null) {
            return;
        }
        context.saveGraphicsState();
        context.translateCTM(this.offset.x, this.offset.y, 0.0f);
        if (this.placeholder != null && this.cachedTextLines.isEmpty()) {
            int placeholderColor = this.defaultPlaceholderColor();
            context.drawText(this.placeholder, 1.0f, 0.0f, placeholderColor, true, font, 0.0f);
        }
        for (TextLine line : this.cachedTextLines) {
            context.drawText(line.formattedText, line.rect.x, line.rect.y, textColor, true, font, 0.0f);
            context.strokeDebugRect(line.index, line.rect);
        }
        this.renderHighlightedRectIfNeeded(context);
        this.renderCursorIfNeeded(context);
        context.restoreGraphicsState();
    }

    public void renderCursorIfNeeded(CGGraphicsContext context) {
        if (!this.isFocused || this.cursorRect == null) {
            return;
        }
        long diff = (System.currentTimeMillis() - this.cursorTimestamp) % 1200L;
        if (diff > 600L) {
            return;
        }
        context.fillRect(this.cursorRect, AppearanceImpl.TEXT_CURSOR_COLOR);
    }

    public void renderHighlightedRectIfNeeded(CGGraphicsContext context) {
        if (!this.isFocused || this.highlightedRects == null || this.highlightedRects.isEmpty()) {
            return;
        }
        IPoseStack.Pose pose = context.state().ctm().last();
        AbstractBufferSource buffers = AbstractBufferSource.buffer();
        IVertexConsumer builder = buffers.getBuffer(SkinRenderType.GUI_HIGHLIGHTED_TEXT);
        for (CGRect rect : this.highlightedRects) {
            builder.vertex(pose, rect.minX(), rect.maxY(), 0.0f).endVertex();
            builder.vertex(pose, rect.maxX(), rect.maxY(), 0.0f).endVertex();
            builder.vertex(pose, rect.maxX(), rect.minY(), 0.0f).endVertex();
            builder.vertex(pose, rect.minX(), rect.minY(), 0.0f).endVertex();
        }
        context.setBlendColor(AppearanceImpl.TEXT_HIGHLIGHTED_COLOR);
        buffers.endBatch();
        context.setBlendColor(UIColor.WHITE);
    }

    public String value() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
        this.setNeedsRemakeTextLine();
    }

    public UIColor textColor() {
        return this.textColor;
    }

    public void setTextColor(UIColor textColor) {
        this.textColor = textColor;
    }

    public NSString placeholder() {
        return this.placeholder;
    }

    public void setPlaceholder(NSString placeholder) {
        this.placeholder = placeholder;
    }

    public UIColor placeholderColor() {
        return this.placeholderColor;
    }

    public void setPlaceholderColor(UIColor placeholderColor) {
        this.placeholderColor = placeholderColor;
    }

    public UIFont font() {
        if (this.font != null) {
            return this.font;
        }
        return UIFont.systemFont();
    }

    public void setFont(UIFont font) {
        this.font = font;
        this.setNeedsRemakeTextLine();
    }

    public void setBoundingSize(CGSize size) {
        this.boundingSize = size;
        this.setNeedsRemakeTextLine();
    }

    public void setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    public NSTextPosition beginOfDocument() {
        return NSTextPosition.ZERO;
    }

    public NSTextPosition endOfDocument() {
        return NSTextPosition.forward(this.value.length());
    }

    public NSTextPosition positionAtPoint(CGPoint point) {
        if (this.cachedFont == null || this.cachedTextLines == null) {
            return null;
        }
        ArrayList<TextLine> selectedLines = new ArrayList<TextLine>();
        if (this.isMultipleLineMode()) {
            for (TextLine line : this.cachedTextLines) {
                if (!line.insideAtY(point.y)) continue;
                selectedLines.add(line);
            }
        } else {
            selectedLines.addAll(this.cachedTextLines);
        }
        for (TextLine line : selectedLines) {
            if (!line.insideAtX(point.x)) continue;
            String value = this.cachedFont._getTextByWidth(line.text, point.x - line.rect.x);
            int index = line.range.startIndex() + value.length();
            return NSTextPosition.forward(index);
        }
        if (!selectedLines.isEmpty()) {
            TextLine line = (TextLine)selectedLines.get(selectedLines.size() - 1);
            return NSTextPosition.backward(line.range.endIndex());
        }
        return this.endOfDocument();
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public void setFocused(boolean focused) {
        this.isFocused = focused;
        if (!this.isFocused) {
            this.setHighlightPos(this.cursorPos);
        }
    }

    public boolean isMultipleLineMode() {
        return this.boundingSize.width != 0.0f;
    }

    public String highlightedText() {
        NSTextPosition startPos = this.min(this.cursorPos, this.highlightPos);
        NSTextPosition endPos = this.max(this.cursorPos, this.highlightPos);
        return this.value.substring(startPos.value, endPos.value);
    }

    public CGRect cursorRect() {
        return this.cursorRect;
    }

    public void setCursorAndHighlightPos(NSTextPosition pos) {
        this.setCursorAndHighlightPos(pos, pos);
    }

    public void setCursorAndHighlightPos(NSTextPosition cursorPos, NSTextPosition highlightPos) {
        this.setCursorPos(cursorPos);
        this.setHighlightPos(highlightPos);
        this.selectionDidChange.run();
    }

    public void checkCursorAndHighlightPos() {
        NSTextPosition cursorPos1 = this.clamp(this.cursorPos, this.beginOfDocument(), this.endOfDocument());
        NSTextPosition highlightPos1 = this.clamp(this.highlightPos, this.beginOfDocument(), this.endOfDocument());
        if (cursorPos1.equals(this.cursorPos) && highlightPos1.equals(this.highlightPos)) {
            return;
        }
        this.setCursorAndHighlightPos(cursorPos1, highlightPos1);
    }

    public NSTextRange selectedTextRange() {
        return new NSTextRange(this.highlightPos, this.cursorPos);
    }

    public void setSelectedTextRange(NSTextRange range) {
        this.setCursorAndHighlightPos(range.end, range.start);
    }

    private void setNeedsRemakeTextLine() {
        this.cachedTextLines = null;
    }

    private void remakeTextLineIfNeeded(CGSize boundingSize, UIFont font) {
        if (this.cachedTextLines != null) {
            return;
        }
        float x = 0.0f;
        float y = 0.0f;
        float lineHeight = font.lineHeight() + (float)this.lineSpacing;
        float maxHeight = 0.0f;
        int lineIndex = 0;
        NSRange selection = NSRange.of(this.cursorPos.value, this.highlightPos.value);
        ArrayList<TextLine> lines = this.split(this.value, selection, font, boundingSize.width);
        for (TextLine line : lines) {
            float width = font._getTextWidth(line.formattedText.characters());
            if (lineIndex != line.index) {
                lineIndex = line.index;
                y += maxHeight;
                x = 0.0f;
            }
            line.rect = new CGRect(x, y, width, lineHeight);
            maxHeight = lineHeight;
            x += width;
        }
        CGRect lastLineRect = new CGRect(0.0f, y + maxHeight, 0.0f, lineHeight);
        this.remakeHighlightedLines(lines, boundingSize, lastLineRect);
        this.cursorRect = this.cursorRectAtIndex(this.cursorPos, lines, lastLineRect);
        this.cachedTextLines = lines;
        this.cachedFont = font;
        this.sizeDidChange.accept(this.cursorRect, new CGSize(x, Math.max(lastLineRect.y, lineHeight)));
    }

    private void remakeHighlightedLines(List<TextLine> lines, CGSize boundingSize, CGRect lastLineRect) {
        if (this.highlightPos.equals(this.cursorPos)) {
            this.highlightedRects = null;
            return;
        }
        CGPoint startPoint = this.pointAtIndex(this.min(this.cursorPos, this.highlightPos), lines, lastLineRect, false);
        CGPoint endPoint = this.pointAtIndex(this.max(this.cursorPos, this.highlightPos), lines, lastLineRect, false);
        if (startPoint.y == endPoint.y) {
            CGRect rect = new CGRect(startPoint.x, startPoint.y, endPoint.x - startPoint.x, lastLineRect.height);
            this.highlightedRects = Collections.singletonList(rect);
            return;
        }
        ArrayList<CGRect> rects = new ArrayList<CGRect>();
        rects.add(new CGRect(startPoint.x, startPoint.y, boundingSize.width - startPoint.x, lastLineRect.height));
        float my = startPoint.y + lastLineRect.height;
        if (my != endPoint.y) {
            rects.add(new CGRect(0.0f, my, boundingSize.width, endPoint.y - my));
        }
        rects.add(new CGRect(0.0f, endPoint.y, endPoint.x, lastLineRect.height));
        this.highlightedRects = rects;
    }

    private NSRange selectionRange() {
        return NSRange.of(this.cursorPos.value, this.highlightPos.value);
    }

    private String formattedString(String value) {
        if (this.isMultipleLineMode()) {
            return value;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (!this.isAllowedChatCharacter(c)) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private CGPoint pointAtIndex(NSTextPosition pos, Iterable<TextLine> lines, CGRect lastLineRect, boolean enabledBackward) {
        if (pos.isBackward && enabledBackward) {
            for (TextLine line : lines) {
                if (line.range.endIndex() != pos.value) continue;
                return line.endPoint();
            }
        }
        for (TextLine line : lines) {
            if (line.range.startIndex() != pos.value) continue;
            return line.startPoint();
        }
        for (TextLine line : lines) {
            if (line.range.endIndex() != pos.value) continue;
            return line.endPoint();
        }
        return new CGPoint(lastLineRect.x, lastLineRect.y);
    }

    private CGRect cursorRectAtIndex(NSTextPosition pos, Iterable<TextLine> lines, CGRect lastLineRect) {
        CGPoint point = this.pointAtIndex(pos, lines, lastLineRect, true);
        return new CGRect(point.x, point.y - 2.0f, 1.0f, lastLineRect.height + 2.0f);
    }

    private int defaultPlaceholderColor() {
        if (this.placeholderColor != null) {
            return this.placeholderColor.value();
        }
        return -13421773;
    }

    private int defaultTextColor() {
        if (this.textColor != null) {
            return this.textColor.value();
        }
        return -1;
    }

    private List<TextLine> split(String value, UIFont font, float maxWidth) {
        if (value.isEmpty()) {
            return Collections.emptyList();
        }
        if (maxWidth == 0.0f) {
            return Collections.singletonList(new TextLine(0, 0, value.length(), value));
        }
        AtomicInteger counter = new AtomicInteger();
        return font._splitLines(value, maxWidth, false, (substring, begin, end) -> new TextLine(counter.getAndIncrement(), begin, end, substring));
    }

    private ArrayList<TextLine> split(String value, NSRange selection, UIFont font, float maxWidth) {
        List<TextLine> wrappedTextLines = this.split(value, font, maxWidth);
        if (wrappedTextLines.isEmpty()) {
            return new ArrayList<TextLine>();
        }
        ArrayList<TextLine> resolvedTextLines = new ArrayList<TextLine>(wrappedTextLines.size() + 2);
        for (TextLine line : wrappedTextLines) {
            if (line.range.intersects(selection) && !line.range.isEmpty()) {
                int lineIndex = line.index;
                int leftStartIndex = line.range.startIndex();
                int leftEndIndex = Math.max(leftStartIndex, selection.startIndex());
                int rightEndIndex = line.range.endIndex();
                int rightStartIndex = Math.min(selection.endIndex(), rightEndIndex);
                if (leftStartIndex != leftEndIndex) {
                    resolvedTextLines.add(new TextLine(lineIndex, leftStartIndex, leftEndIndex, value.substring(leftStartIndex, leftEndIndex)));
                }
                if (leftEndIndex != rightStartIndex) {
                    resolvedTextLines.add(new TextLine(lineIndex, leftEndIndex, rightStartIndex, value.substring(leftEndIndex, rightStartIndex)));
                }
                if (rightStartIndex == rightEndIndex) continue;
                resolvedTextLines.add(new TextLine(lineIndex, rightStartIndex, rightEndIndex, value.substring(rightStartIndex, rightEndIndex)));
                continue;
            }
            resolvedTextLines.add(line);
        }
        return resolvedTextLines;
    }

    NSTextPosition clamp(NSTextPosition value, NSTextPosition minValue, NSTextPosition maxValue) {
        if (value.value < minValue.value) {
            return minValue;
        }
        if (value.value > maxValue.value) {
            return maxValue;
        }
        return value;
    }

    NSTextPosition min(NSTextPosition value, NSTextPosition value1) {
        if (value.value < value1.value) {
            return value;
        }
        return value1;
    }

    NSTextPosition max(NSTextPosition value, NSTextPosition value1) {
        if (value.value > value1.value) {
            return value;
        }
        return value1;
    }

    void moveCursorTo(TextTokenizer tokenizer, int count, boolean selectMode) {
        int index = tokenizer.advance(this.value, this.cursorPos.value, count);
        this.moveCursorTo(NSTextPosition.forward(index), selectMode);
    }

    void moveCursorTo(NSTextPosition pos, boolean selectMode) {
        if (selectMode) {
            this.setCursorAndHighlightPos(pos, this.highlightPos);
        } else {
            this.setCursorAndHighlightPos(pos, pos);
        }
    }

    boolean isAllowedChatCharacter(char c) {
        return c != '\u00a7' && c >= ' ' && c != '\u007f';
    }

    static interface TextTokenizer {
        public static final TextTokenizer WORLD_AFTER = (value, index, step) -> {
            for (int k = 0; k < step; ++k) {
                int l = value.length();
                if ((index = value.indexOf(32, index)) == -1) {
                    index = l;
                    continue;
                }
                while (index < l && value.charAt(index) == ' ') {
                    ++index;
                }
            }
            return index;
        };
        public static final TextTokenizer WORLD_BEFORE = (value, index, step) -> {
            for (int k = 0; k < step; ++k) {
                while (index > 0 && value.charAt(index - 1) == ' ') {
                    --index;
                }
                while (index > 0 && value.charAt(index - 1) != ' ') {
                    --index;
                }
            }
            return index;
        };
        public static final TextTokenizer CHAR_AFTER = (value, index, step) -> {
            int length = value.length();
            for (int k = 0; index < length && k < step; ++k) {
                if (!Character.isHighSurrogate(value.charAt(index++)) || index >= length || !Character.isLowSurrogate(value.charAt(index))) continue;
                ++index;
            }
            return index;
        };
        public static final TextTokenizer CHAR_BEFORE = (value, index, step) -> {
            for (int k = 0; index > 0 && k < step; ++k) {
                if (!Character.isLowSurrogate(value.charAt(--index)) || index <= 0 || !Character.isHighSurrogate(value.charAt(index - 1))) continue;
                --index;
            }
            return index;
        };

        public int advance(String var1, int var2, int var3);
    }

    static class TextLine {
        final int index;
        final String text;
        final NSString formattedText;
        final NSRange range;
        CGRect rect = CGRect.ZERO;

        TextLine(int index, int startIndex, int endIndex, String text) {
            this.text = text;
            this.formattedText = new FormattedStringImpl(text);
            this.index = index;
            this.range = new NSRange(startIndex, endIndex - startIndex);
        }

        boolean insideAtX(float x) {
            return this.rect.minX() <= x && x < this.rect.maxX();
        }

        boolean insideAtY(float y) {
            return this.rect.minY() <= y && y < this.rect.maxY();
        }

        CGPoint startPoint() {
            return new CGPoint(this.rect.x, this.rect.y);
        }

        CGPoint endPoint() {
            return new CGPoint(this.rect.x + this.rect.width, this.rect.y);
        }
    }
}

