/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.ABI;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocument;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentExporter;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentImporter;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentListeners;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentNode;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentProvider;
import moe.plushie.armourers_workshop.core.skin.serializer.document.SkinDocumentSynchronizer;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.core.utils.SkinUtils;
import moe.plushie.armourers_workshop.init.environment.EnvironmentExecutor;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class AdvancedBuilderBlockEntity
extends UpdatableBlockEntity
implements SkinDocumentProvider {
    private AxisAlignedBB renderBoundingBox;
    public final OpenVector3f carmeOffset = new OpenVector3f();
    public final OpenVector3f carmeRot = new OpenVector3f();
    public final OpenVector3f carmeScale = new OpenVector3f(1.0f, 1.0f, 1.0f);
    public OpenVector3f offset = new OpenVector3f(0.0f, 12.0f, 0.0f);
    private final SkinDocument document = new SkinDocument();

    public OpenVector3f getRenderOrigin() {
        BlockPos pos = this.func_174877_v();
        return new OpenVector3f((float)pos.func_177958_n() + this.offset.x() + 0.5f, (float)pos.func_177956_o() + this.offset.y() + 0.5f, (float)pos.func_177952_p() + this.offset.z() + 0.5f);
    }

    public AdvancedBuilderBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
        this.document.addListener(new SkinDocumentListeners.Updater(this));
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.document.deserialize(serializer);
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        this.document.serialize(serializer);
    }

    public void importToNode(String identifier, Skin skin, SkinDocumentNode node) {
        SkinDocumentSynchronizer synchronizer = new SkinDocumentSynchronizer(this, false);
        this.document.addListener(synchronizer);
        node.setSkin(new SkinDescriptor(identifier, skin.type()));
        this.document.removeListener(synchronizer);
        if (skin.itemTransforms() != null) {
            this.importToSettings(skin.itemTransforms(), node);
        }
    }

    private void importToSettings(OpenItemTransforms itemTransforms, SkinDocumentNode node) {
        Collection<String> overrideNames;
        OpenItemTransforms newItemTransforms = new OpenItemTransforms();
        if (this.document.itemTransforms() != null) {
            newItemTransforms.putAll(this.document.itemTransforms());
        }
        if (!(overrideNames = SkinUtils.getItemOverrides(node.type())).isEmpty()) {
            overrideNames.forEach(name -> itemTransforms.forEach((type, transform) -> newItemTransforms.put(name + ";" + type, transform)));
        } else {
            newItemTransforms.putAll(itemTransforms);
        }
        SkinDocumentSynchronizer synchronizer = new SkinDocumentSynchronizer(this, false);
        this.document.addListener(synchronizer);
        this.document.setItemTransforms(newItemTransforms);
        this.document.removeListener(synchronizer);
    }

    public void importToDocument(String identifier, Skin skin) {
        BlockUtils.performBatch(() -> {
            SkinDocumentImporter importer = new SkinDocumentImporter(this.document);
            this.document.reset();
            this.document.setItemTransforms(skin.itemTransforms());
            importer.execute(identifier, skin);
        });
    }

    public void exportFromDocument(ServerPlayerEntity player, GameProfile profile) {
        SkinDocumentExporter exporter = new SkinDocumentExporter(this.document);
        exporter.setItemTransforms(this.document.itemTransforms());
        EnvironmentExecutor.runOnBackground(() -> () -> {
            try {
                Skin skin = exporter.execute((PlayerEntity)player, profile);
                player.field_71133_b.execute(() -> {
                    String identifier = SkinLoader.getInstance().saveSkin("", skin);
                    SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.type());
                    ItemStack itemStack = descriptor.asItemStack();
                    ABI.giveItem((PlayerEntity)player, itemStack);
                });
            }
            catch (TranslatableException exception) {
                UserNotifications.sendErrorMessage(exception.getComponent(), (PlayerEntity)player);
            }
        });
    }

    @Override
    public SkinDocument document() {
        return this.document;
    }

    @Override
    public AxisAlignedBB getVisibleBox(BlockState blockState) {
        if (this.renderBoundingBox != null) {
            return this.renderBoundingBox;
        }
        float s = 16.0f;
        OpenVector3f origin = this.getRenderOrigin();
        OpenRectangle3f rect = new OpenRectangle3f(origin.x() - s / 2.0f, origin.y() - s / 2.0f, origin.z() - s / 2.0f, s, s, s);
        this.renderBoundingBox = new AxisAlignedBB((double)rect.minX(), (double)rect.minY(), (double)rect.minZ(), (double)rect.maxX(), (double)rect.maxY(), (double)rect.maxZ());
        return this.renderBoundingBox;
    }
}

