/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.blockentity;

import java.util.Arrays;
import java.util.Map;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataSerializer;
import moe.plushie.armourers_workshop.api.core.IDataSerializerKey;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.core.blockentity.UpdatableBlockEntity;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.math.OpenVector2i;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenRotation;
import moe.plushie.armourers_workshop.core.utils.TextureUtils;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BoundingBoxBlockEntity
extends UpdatableBlockEntity
implements IBlockPaintable {
    protected OpenVector3i guide = OpenVector3i.ZERO;
    protected BlockPos parent = null;
    protected SkinPartType partType = SkinPartTypes.UNKNOWN;
    private ArmourerBlockEntity cachedParentBlockEntity;
    private boolean customRenderer = false;

    public BoundingBoxBlockEntity(TileEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public void readAdditionalData(IDataSerializer serializer) {
        this.parent = serializer.read(CodingKeys.REFER);
        this.guide = serializer.read(CodingKeys.OFFSET);
        this.partType = serializer.read(CodingKeys.PART_TYPE);
        this.customRenderer = Arrays.stream(OpenDirection.values()).anyMatch(this::shouldChangeColor);
        this.cachedParentBlockEntity = null;
    }

    @Override
    public void writeAdditionalData(IDataSerializer serializer) {
        serializer.write(CodingKeys.REFER, this.parent);
        serializer.write(CodingKeys.OFFSET, this.guide);
        serializer.write(CodingKeys.PART_TYPE, this.partType);
    }

    public SkinPartType partType() {
        return this.partType;
    }

    public void setPartType(SkinPartType partType) {
        this.partType = partType;
    }

    public BlockPos parent() {
        return this.parent;
    }

    public void setParent(BlockPos parent) {
        this.cachedParentBlockEntity = null;
        this.parent = parent;
    }

    public OpenVector3i guide() {
        return this.guide;
    }

    public void setGuide(OpenVector3i guide) {
        this.guide = guide;
    }

    public boolean isValid() {
        ArmourerBlockEntity blockEntity = this.parentBlockEntity();
        if (blockEntity != null && blockEntity.skinType() != null) {
            return blockEntity.skinType().parts().contains(this.partType);
        }
        return false;
    }

    public boolean hasColors() {
        ArmourerBlockEntity blockEntity = this.parentBlockEntity();
        if (blockEntity == null) {
            return false;
        }
        for (OpenDirection dir : OpenDirection.values()) {
            SkinPaintColor paintColor = this.getArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, dir));
            if (paintColor == SkinPaintColor.CLEAR) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldChangeColor(OpenDirection direction) {
        return this.getTexturePos(this.parentBlockEntity(), direction) != null;
    }

    @Override
    public SkinPaintColor getColor(OpenDirection direction) {
        OpenVector2i texturePos;
        ArmourerBlockEntity blockEntity = this.parentBlockEntity();
        SkinPaintColor color = this.getArmourerTextureColor(blockEntity, texturePos = this.getTexturePos(blockEntity, direction));
        if (color != null && color.paintType() != SkinPaintTypes.NONE) {
            return color;
        }
        World level = this.func_145831_w();
        if (level != null && level.func_201670_d()) {
            return this.getTextureColor(blockEntity, texturePos);
        }
        return SkinPaintColor.CLEAR;
    }

    @Override
    public void setColor(OpenDirection direction, SkinPaintColor color) {
    }

    @Override
    public void setColors(Map<OpenDirection, SkinPaintColor> colors) {
        ArmourerBlockEntity blockEntity = this.parentBlockEntity();
        colors.forEach((dir, color) -> this.setArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, (OpenDirection)dir), (SkinPaintColor)color));
    }

    @Override
    public boolean hasColor(OpenDirection direction) {
        return this.getColor(direction) != SkinPaintColor.CLEAR;
    }

    public void clearArmourerTextureColors() {
        ArmourerBlockEntity blockEntity = this.parentBlockEntity();
        if (blockEntity == null || this.func_145831_w() == null) {
            return;
        }
        for (OpenDirection dir : OpenDirection.values()) {
            this.setArmourerTextureColor(blockEntity, this.getTexturePos(blockEntity, dir), SkinPaintColor.CLEAR);
        }
    }

    public SkinPaintColor getArmourerTextureColor(ArmourerBlockEntity blockEntity, OpenVector2i texturePos) {
        SkinPaintColor color;
        if (texturePos != null && blockEntity != null && (color = blockEntity.getPaintColor(texturePos)) != null) {
            return color;
        }
        return SkinPaintColor.CLEAR;
    }

    public void setArmourerTextureColor(ArmourerBlockEntity blockEntity, OpenVector2i texturePos, SkinPaintColor color) {
        if (texturePos != null && blockEntity != null) {
            blockEntity.setPaintColor(texturePos, color);
            BlockUtils.combine(blockEntity, blockEntity::sendBlockUpdates);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private SkinPaintColor getTextureColor(ArmourerBlockEntity blockEntity, OpenVector2i texturePos) {
        SkinPaintColor color;
        if (texturePos != null && blockEntity != null && (color = TextureUtils.getPlayerTextureModelColor(blockEntity.textureDescriptor(), texturePos)) != null) {
            return color;
        }
        return SkinPaintColor.CLEAR;
    }

    private OpenVector2i getTexturePos(ArmourerBlockEntity blockEntity, OpenDirection direction) {
        if (blockEntity != null) {
            return blockEntity.getTexturePos(this.partType, this.guide, this.getResolvedDirection(blockEntity, direction));
        }
        return null;
    }

    private OpenDirection getResolvedDirection(ArmourerBlockEntity blockEntity, OpenDirection dir) {
        OpenDirection openDirection;
        if (blockEntity == null) {
            return dir;
        }
        switch (blockEntity.facing()) {
            case SOUTH: {
                openDirection = OpenRotation.CLOCKWISE_180.rotate(dir);
                break;
            }
            case WEST: {
                openDirection = OpenRotation.CLOCKWISE_90.rotate(dir);
                break;
            }
            case EAST: {
                openDirection = OpenRotation.COUNTERCLOCKWISE_90.rotate(dir);
                break;
            }
            default: {
                openDirection = dir;
            }
        }
        return openDirection;
    }

    private ArmourerBlockEntity parentBlockEntity() {
        if (this.cachedParentBlockEntity != null) {
            if (this.cachedParentBlockEntity.func_145837_r()) {
                return null;
            }
            return this.cachedParentBlockEntity;
        }
        World level = this.func_145831_w();
        if (level == null || this.parent == null) {
            return null;
        }
        BlockPos target = this.func_174877_v().func_177973_b((Vector3i)this.parent);
        TileEntity tileEntity = level.func_175625_s(target);
        if (tileEntity instanceof ArmourerBlockEntity) {
            ArmourerBlockEntity blockEntity;
            this.cachedParentBlockEntity = blockEntity = (ArmourerBlockEntity)tileEntity;
            return this.cachedParentBlockEntity;
        }
        return null;
    }

    public boolean isCustomRenderer() {
        if (this.customRenderer) {
            return this.isValid();
        }
        return false;
    }

    private static class CodingKeys {
        public static final IDataSerializerKey<BlockPos> REFER = IDataSerializerKey.create("Refer", IDataCodec.BLOCK_POS, null);
        public static final IDataSerializerKey<OpenVector3i> OFFSET = IDataSerializerKey.create("Offset", OpenVector3i.CODEC, OpenVector3i.ZERO);
        public static final IDataSerializerKey<SkinPartType> PART_TYPE = IDataSerializerKey.create("PartType", SkinPartTypes.CODEC, SkinPartTypes.UNKNOWN);

        private CodingKeys() {
        }
    }
}

