/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.foundation.NSTextAlignment;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.builder.client.gui.advancedbuilder.panel.AdvancedPanel;
import moe.plushie.armourers_workshop.builder.client.gui.widget.NewSlider;
import moe.plushie.armourers_workshop.builder.data.properties.DataProperty;
import moe.plushie.armourers_workshop.builder.data.properties.Vector3dProperty;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;

public class EntitySizeBox
extends UIView {
    private float cursorY = 0.0f;
    private float cursorX = 0.0f;
    private final Vector3dProperty valueProperty = new Vector3dProperty(0.6f, 1.88f, 1.62f);

    public EntitySizeBox(CGRect frame) {
        super(frame);
        this.addSlider(this.getDisplayText("overrideEntityWidth", new Object[0]), this.valueProperty.x());
        this.addSlider(this.getDisplayText("overrideEntityHeight", new Object[0]), this.valueProperty.y());
        this.addSlider(this.getDisplayText("overrideEntityEyeHeight", new Object[0]), this.valueProperty.z());
        for (UIView child : this.subviews()) {
            if (!(child instanceof NewSlider)) continue;
            CGRect nframe = child.frame().copy();
            nframe.setX(this.cursorX + 8.0f);
            nframe.setWidth(this.bounds().width() - this.cursorX - 8.0f);
            child.setFrame(nframe);
            child.setAutoresizingMask(34);
        }
    }

    public void addObserver(Consumer<OpenVector3d> observer) {
        this.valueProperty.addObserver(observer);
    }

    public void addEditingObserver(Consumer<Boolean> observer) {
        this.valueProperty.addEditingObserver(observer);
    }

    public void setValue(OpenVector3d value) {
        this.valueProperty.set(value);
    }

    public OpenVector3d getValue() {
        return (OpenVector3d)this.valueProperty.get();
    }

    private void addSlider(NSString name, DataProperty<Double> property) {
        UILabel title = new UILabel(new CGRect(0.0f, this.cursorY + 3.0f, 80.0f, 10.0f));
        title.setText(name);
        title.setTextColor(UIColor.WHITE);
        title.setTextHorizontalAlignment(NSTextAlignment.Horizontal.LEFT);
        title.sizeToFit();
        this.cursorX = Math.max(this.cursorX, title.frame().width());
        NewSlider view = new NewSlider(new CGRect(0.0f, this.cursorY, 80.0f, 16.0f));
        view.setFormatter(AdvancedPanel.Group.Unit.POINT);
        view.setStepValue(0.01);
        view.setMinValue(0.01);
        view.setMaxValue(10.0);
        view.setValue(property.getOrDefault(0.0));
        view.addTarget(this, UIControl.Event.EDITING_DID_BEGIN, (pro, ctrl) -> property.beginEditing());
        view.addTarget(this, UIControl.Event.EDITING_DID_END, (pro, ctrl) -> property.endEditing());
        view.addTarget(this, UIControl.Event.VALUE_CHANGED, (pro, ctrl) -> {
            NewSlider slider = (NewSlider)ctrl;
            property.set(slider.value());
        });
        property.addObserver(view::setValue);
        this.addSubview(title);
        this.addSubview(view);
        this.cursorY = view.frame().maxY();
    }

    protected NSString getDisplayText(String key, Object ... objects) {
        return NSString.localizedString("armourer.skinSettings." + key, objects);
    }
}

