/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.gui.widget;

import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UICheckBox;
import com.apple.library.uikit.UIColor;
import com.apple.library.uikit.UIControl;
import com.apple.library.uikit.UILabel;
import com.apple.library.uikit.UIView;
import java.util.Collection;
import moe.plushie.armourers_workshop.builder.client.gui.widget.EntitySizeBox;
import moe.plushie.armourers_workshop.core.client.gui.widget.InventoryBox;
import moe.plushie.armourers_workshop.core.client.gui.widget.VerticalStackView;
import moe.plushie.armourers_workshop.core.math.OpenVector3d;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.utils.Objects;

public abstract class PropertySettingView
extends UIView {
    protected final VerticalStackView stackView = new VerticalStackView(CGRect.ZERO);
    protected UICheckBox blockBed;
    protected UICheckBox blockEnderInventory;
    protected UICheckBox blockInventory;
    protected UILabel inventoryTitle;
    protected UILabel inventorySlot;
    protected InventoryBox inventoryBox;
    protected EntitySizeBox entitySizeBox;

    public PropertySettingView(CGRect rect, Collection<SkinProperty<?>> properties) {
        super(rect);
        this.stackView.setFrame(this.bounds());
        this.stackView.setAutoresizingMask(18);
        this.addSubview(this.stackView);
        for (SkinProperty<?> property : properties) {
            if (property.defaultValue() instanceof Boolean) {
                this.addCheckBox((SkinProperty)Objects.unsafeCast(property));
            }
            if (property == SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH) {
                this.addEntitySize();
            }
            if (property != SkinProperty.BLOCK_INVENTORY_WIDTH) continue;
            this.addInventoryBox();
        }
        this.stackView.sizeToFit();
        this.setFrame(new CGRect(rect.x, rect.y, rect.width, this.stackView.frame().maxY()));
        this.resolveConflicts();
    }

    public void beginEditing() {
    }

    public abstract <T> void putValue(SkinProperty<T> var1, T var2);

    public abstract <T> T getValue(SkinProperty<T> var1);

    public void endEditing() {
    }

    protected void addCheckBox(SkinProperty<Boolean> property) {
        UICheckBox checkBox = new UICheckBox(new CGRect(0.0f, 0.0f, 80.0f, 10.0f));
        checkBox.setTitle(this.getDisplayText(property.key(), new Object[0]));
        checkBox.setTitleColor(UIColor.WHITE);
        checkBox.setTitleColor(UIColor.GRAY, 4);
        checkBox.setSelected(this.getValue(property));
        checkBox.addTarget(this, UIControl.Event.VALUE_CHANGED, (self, c) -> {
            UICheckBox checkBox1 = (UICheckBox)Objects.unsafeCast(c);
            self.beginEditing();
            self.putValue(property, checkBox1.isSelected());
            self.resolveConflicts();
            self.endEditing();
        });
        this.stackView.addArrangedSubview(checkBox);
        if (property == SkinProperty.BLOCK_BED) {
            checkBox.setFrame(checkBox.frame().insetBy(0.0f, 4.0f, 0.0f, 0.0f));
            this.blockBed = checkBox;
        }
        if (property == SkinProperty.BLOCK_ENDER_INVENTORY) {
            this.blockEnderInventory = checkBox;
        }
        if (property == SkinProperty.BLOCK_INVENTORY) {
            this.blockInventory = checkBox;
        }
    }

    protected void addEntitySize() {
        UIView contentView = new UIView(new CGRect(0.0f, 0.0f, 80.0f, 48.0f));
        this.entitySizeBox = new EntitySizeBox(new CGRect(12.0f, 0.0f, 56.0f, 48.0f));
        this.entitySizeBox.setAutoresizingMask(18);
        this.entitySizeBox.setHidden(true);
        this.entitySizeBox.addEditingObserver(flag -> {
            if (flag.booleanValue()) {
                this.beginEditing();
            } else {
                this.endEditing();
            }
        });
        this.entitySizeBox.addObserver(value -> {
            this.putValue(SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH, value.x());
            this.putValue(SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT, value.y());
            this.putValue(SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT, value.z());
        });
        contentView.addSubview(this.entitySizeBox);
        this.stackView.addArrangedSubview(contentView);
    }

    protected void addInventoryBox() {
        UIView contentView = new UIView(new CGRect(0.0f, 0.0f, 80.0f, 60.0f));
        this.inventoryTitle = new UILabel(new CGRect(0.0f, -2.0f, 80.0f, 9.0f));
        this.inventoryTitle.setAutoresizingMask(34);
        this.inventoryTitle.setText(this.getDisplayText("label.inventorySize", new Object[0]));
        contentView.addSubview(this.inventoryTitle);
        this.inventorySlot = new UILabel(new CGRect(0.0f, 6.0f, 80.0f, 9.0f));
        this.inventorySlot.setAutoresizingMask(34);
        contentView.addSubview(this.inventorySlot);
        this.inventoryBox = new InventoryBox(new CGRect(0.0f, 0.0f, 90.0f, 60.0f));
        this.inventoryBox.setAutoresizingMask(36);
        this.inventoryBox.addTarget(this, UIControl.Event.VALUE_CHANGED, PropertySettingView::setInventorySize);
        contentView.addSubview(this.inventoryBox);
        this.stackView.addArrangedSubview(contentView);
    }

    private void setInventorySize(UIControl sender) {
        CGPoint offset = this.inventoryBox.offset();
        int width = (int)(offset.x / 10.0f) + 1;
        int height = (int)(offset.y / 10.0f) + 1;
        this.beginEditing();
        this.putValue(SkinProperty.BLOCK_INVENTORY_WIDTH, width);
        this.putValue(SkinProperty.BLOCK_INVENTORY_HEIGHT, height);
        this.endEditing();
        this.resolveInventorySlots();
    }

    private void resolveEntitySize() {
        if (this.entitySizeBox == null) {
            return;
        }
        Boolean isEnabled = this.getValue(SkinProperty.OVERRIDE_ENTITY_SIZE);
        Double width = this.getValue(SkinProperty.OVERRIDE_ENTITY_SIZE_WIDTH);
        Double height = this.getValue(SkinProperty.OVERRIDE_ENTITY_SIZE_HEIGHT);
        Double eyeHeight = this.getValue(SkinProperty.OVERRIDE_ENTITY_SIZE_EYE_HEIGHT);
        this.entitySizeBox.setValue(new OpenVector3d(width, height, eyeHeight));
        this.entitySizeBox.setHidden(isEnabled == false);
    }

    private void resolveInventorySlots() {
        if (this.inventorySlot == null) {
            return;
        }
        boolean isEnabled = this.getValue(SkinProperty.BLOCK_INVENTORY) != false && this.getValue(SkinProperty.BLOCK_ENDER_INVENTORY) == false;
        Integer width = this.getValue(SkinProperty.BLOCK_INVENTORY_WIDTH);
        Integer height = this.getValue(SkinProperty.BLOCK_INVENTORY_HEIGHT);
        this.inventorySlot.setText(this.getDisplayText("label.inventorySlots", width * height, width, height));
        this.inventoryBox.setOffset(new CGPoint(Math.max(width - 1, 0) * 10, Math.max(height - 1, 0) * 10));
        this.inventoryTitle.setHidden(!isEnabled);
        this.inventorySlot.setHidden(!isEnabled);
        this.inventoryBox.setHidden(!isEnabled);
    }

    private void resolveConflicts() {
        if (this.blockBed != null) {
            this.blockBed.setEnabled(this.getValue(SkinProperty.BLOCK_MULTIBLOCK));
            if (!this.blockBed.isEnabled() && this.blockBed.isSelected()) {
                this.blockBed.setSelected(false);
                this.putValue(SkinProperty.BLOCK_BED, false);
            }
        }
        if (this.blockEnderInventory != null) {
            this.blockEnderInventory.setEnabled(this.getValue(SkinProperty.BLOCK_INVENTORY) == false);
            if (!this.blockEnderInventory.isEnabled() && this.blockEnderInventory.isSelected()) {
                this.blockEnderInventory.setSelected(false);
                this.putValue(SkinProperty.BLOCK_ENDER_INVENTORY, false);
            }
        }
        if (this.blockInventory != null) {
            this.blockInventory.setEnabled(this.getValue(SkinProperty.BLOCK_ENDER_INVENTORY) == false);
            if (!this.blockInventory.isEnabled() && this.blockInventory.isSelected()) {
                this.blockInventory.setSelected(false);
                this.putValue(SkinProperty.BLOCK_INVENTORY, false);
            }
        }
        this.resolveEntitySize();
        this.resolveInventorySlots();
    }

    protected NSString getDisplayText(String key, Object ... objects) {
        return NSString.localizedString("armourer.skinSettings." + key, objects);
    }
}

