/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.client.render;

import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.builder.item.SkinCubeItem;
import moe.plushie.armourers_workshop.compatibility.client.renderer.AbstractItemStackRenderer;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.render.ExtendedFaceRenderer;
import moe.plushie.armourers_workshop.core.data.color.BlockPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.init.ModBlocks;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinCubeItemRenderer
extends AbstractItemStackRenderer {
    private static SkinCubeItemRenderer INSTANCE;

    public static SkinCubeItemRenderer getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SkinCubeItemRenderer();
        }
        return INSTANCE;
    }

    @Override
    public void renderByItem(ItemStack itemStack, OpenItemDisplayContext itemDisplayContext, IPoseStack poseStack, IBufferSource bufferSource, int light, int overlay) {
        Block block;
        if (itemStack.func_190926_b()) {
            return;
        }
        SkinCubeItem item = (SkinCubeItem)itemStack.func_77973_b();
        BlockPaintColor blockPaintColor = item.getItemColors(itemStack);
        if (blockPaintColor == null) {
            blockPaintColor = BlockPaintColor.WHITE;
        }
        boolean isGlowing = (block = item.func_179223_d()).equals(ModBlocks.SKIN_CUBE_GLOWING.get()) || block.equals(ModBlocks.SKIN_CUBE_GLASS_GLOWING.get());
        boolean isGlass = block.equals(ModBlocks.SKIN_CUBE_GLASS.get()) || block.equals(ModBlocks.SKIN_CUBE_GLASS_GLOWING.get());
        IRenderType renderType = SkinRenderType.BLOCK_CUBE;
        if (isGlass) {
            renderType = SkinRenderType.BLOCK_CUBE_GLASS;
        }
        if (isGlowing) {
            float f1 = 0.0625f;
            float f = 0.875f;
            IVertexConsumer builder2 = bufferSource.getBuffer(renderType);
            poseStack.pushPose();
            poseStack.translate(f1, f1, f1);
            poseStack.scale(f, f, f);
            this.renderCube(blockPaintColor, light, overlay, poseStack, builder2);
            poseStack.popPose();
            renderType = SkinRenderType.BLOCK_CUBE_GLASS_UNSORTED;
        }
        IVertexConsumer builder1 = bufferSource.getBuffer(renderType);
        this.renderCube(blockPaintColor, light, overlay, poseStack, builder1);
    }

    public void renderCube(BlockPaintColor blockPaintColor, int light, int overlay, IPoseStack poseStack, IVertexConsumer builder) {
        for (OpenDirection dir : OpenDirection.values()) {
            SkinPaintColor paintColor = blockPaintColor.getOrDefault(dir, SkinPaintColor.WHITE);
            ExtendedFaceRenderer.render2(0, 0, 0, dir, paintColor, 255, light, overlay, poseStack, builder);
        }
    }
}

