/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.item;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.common.IBlockPaintViewer;
import moe.plushie.armourers_workshop.api.common.IConfigurableToolProperty;
import moe.plushie.armourers_workshop.api.common.IItemModelProperty;
import moe.plushie.armourers_workshop.api.common.IItemPropertiesProvider;
import moe.plushie.armourers_workshop.api.common.IItemTintColorProvider;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.builder.item.AbstractPaintToolItem;
import moe.plushie.armourers_workshop.builder.item.option.PaintingToolOptions;
import moe.plushie.armourers_workshop.builder.network.UpdateColorPickerPacket;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ToolAPI;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IItemPaintable;
import moe.plushie.armourers_workshop.core.data.paint.IPaintProvider;
import moe.plushie.armourers_workshop.core.data.paint.IPaintToolPicker;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintTypes;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModSounds;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ColorPickerItem
extends AbstractPaintToolItem
implements IItemTintColorProvider,
IItemPropertiesProvider,
IItemPaintable,
IPaintToolPicker,
IBlockPaintViewer {
    public ColorPickerItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return this.usePickTool(context);
    }

    @Override
    public ActionResultType usePickTool(World level, BlockPos pos, OpenDirection dir, TileEntity blockEntity, ItemUseContext context) {
        ItemStack itemStack = context.func_195996_i();
        if (blockEntity instanceof IBlockPaintable) {
            IBlockPaintable paintable = (IBlockPaintable)blockEntity;
            if (!level.func_201670_d()) {
                return ActionResultType.CONSUME;
            }
            SkinPaintColor color = paintable.getColor(dir);
            ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), color);
            UpdateColorPickerPacket packet = new UpdateColorPickerPacket(context.func_221531_n(), itemStack);
            NetworkManager.sendToServer(packet);
            this.playSound(context);
            return ActionResultType.SUCCESS;
        }
        if (blockEntity instanceof IPaintProvider) {
            IPaintProvider provider = (IPaintProvider)blockEntity;
            PlayerEntity player = context.func_195999_j();
            if (player != null && !player.func_226563_dT_()) {
                return ActionResultType.PASS;
            }
            SkinPaintColor newColor = this.getItemColor(itemStack);
            if (newColor == null) {
                return ActionResultType.CONSUME;
            }
            if (!ToolAPI.get(itemStack, PaintingToolOptions.CHANGE_PAINT_TYPE).booleanValue()) {
                newColor = newColor.withPaintType(provider.color().paintType());
            }
            provider.setColor(newColor);
            return ActionResultType.func_233537_a_((boolean)level.func_201670_d());
        }
        return ActionResultType.PASS;
    }

    @Override
    public void createModelProperties(BiConsumer<IResourceLocation, IItemModelProperty> builder) {
        builder.accept(ModConstants.key("empty"), (itemStack, level, entity, id) -> ComponentAPI.has(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get()) ? 0.0f : 1.0f);
    }

    @Override
    public void createToolProperties(Consumer<IConfigurableToolProperty<?>> builder) {
        builder.accept(PaintingToolOptions.CHANGE_PAINT_TYPE);
    }

    @Override
    public void appendColorHoverText(ItemStack itemStack, List<ITextComponent> tooltips) {
        SkinPaintColor paintColor = this.getItemColor(itemStack);
        if (paintColor != null) {
            tooltips.addAll(ColorUtils.getColorTooltips(paintColor, false));
        } else {
            tooltips.add((ITextComponent)TranslateUtils.subtitle("item.armourers_workshop.rollover.empty", new Object[0]));
        }
    }

    @Override
    public void setItemColor(ItemStack itemStack, SkinPaintColor paintColor) {
        ComponentAPI.set(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get(), paintColor);
    }

    @Override
    public SkinPaintColor getItemColor(ItemStack itemStack) {
        return (SkinPaintColor)ComponentAPI.get(itemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
    }

    @Override
    public int getTintColor(ItemStack itemStack, int index) {
        if (index == 1) {
            return ColorUtils.getDisplayRGB(itemStack);
        }
        return -1;
    }

    public boolean func_77636_d(ItemStack itemStack) {
        SkinPaintColor paintColor = this.getItemColor(itemStack, SkinPaintColor.WHITE);
        return paintColor.paintType() != SkinPaintTypes.NORMAL;
    }

    @Override
    public IRegistryHolder<SoundEvent> getItemSoundEvent(ItemUseContext context) {
        return ModSounds.PICKER;
    }
}

