/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.menu;

import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Map;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.core.math.IVector2i;
import moe.plushie.armourers_workshop.api.skin.part.ISkinPartTypeTextured;
import moe.plushie.armourers_workshop.builder.blockentity.OutfitMakerBlockEntity;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.core.data.UserNotifications;
import moe.plushie.armourers_workshop.core.menu.AbstractBlockEntityMenu;
import moe.plushie.armourers_workshop.core.menu.SkinSlot;
import moe.plushie.armourers_workshop.core.menu.SkinSlotType;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinLoader;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.part.SkinPart;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.SkinLoadException;
import moe.plushie.armourers_workshop.core.skin.serializer.exception.TranslatableException;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintData;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class OutfitMakerMenu
extends AbstractBlockEntityMenu<OutfitMakerBlockEntity> {
    private final IInventory inventory;

    public OutfitMakerMenu(ContainerType<?> menuType, Block block, int containerId, PlayerInventory playerInventory, IGlobalPos access) {
        super((ContainerType)menuType, block, containerId, access);
        this.inventory = ((OutfitMakerBlockEntity)this.blockEntity).getInventory();
        this.addPlayerSlots((IInventory)playerInventory, 8, 158);
        this.addInputSlots(this.inventory, 0, this.inventory.func_70302_i_() - 1, 36, 58);
        this.addOutputSlot(this.inventory, this.inventory.func_70302_i_() - 1, 148, 88);
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        return this.quickMoveStack(player, index, this.field_75151_b.size() - 1);
    }

    public boolean shouldCrafting() {
        if (!this.outputStack().func_190926_b()) {
            return false;
        }
        for (ItemStack itemStack : this.inputStacks()) {
            if (itemStack.func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void saveArmourItem(PlayerEntity player, GameProfile profile) {
        if (!this.shouldCrafting()) {
            return;
        }
        try {
            this.saveArmourItemWithProfile(profile, (OutfitMakerBlockEntity)this.blockEntity);
        }
        catch (TranslatableException exception) {
            SystemMessageProvider.sendSystemMessage(player, exception.getComponent());
            UserNotifications.sendErrorMessage(exception.getComponent(), player);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveArmourItemWithProfile(GameProfile profile, OutfitMakerBlockEntity blockEntity) throws Exception {
        ArrayList<SkinPart> skinParts = new ArrayList<SkinPart>();
        SkinProperties properties = new SkinProperties();
        String partIndexs = "";
        SkinPaintData paintData = null;
        boolean paintDataVersion = false;
        int skinIndex = 0;
        for (ItemStack itemStack : this.inputStacks()) {
            SkinDescriptor descriptor = SkinDescriptor.of(itemStack);
            Skin skin = SkinLoader.getInstance().loadSkin(descriptor.identifier());
            if (skin == null) continue;
            if (!skin.isBasicOnly()) {
                throw SkinLoadException.Type.NOT_SUPPORTED_CONTENT.build("notSupportContent", new Object[0]);
            }
            if (!skin.settings().isEditable()) {
                throw SkinLoadException.Type.NOT_EDITABLE.build("notEditable", new Object[0]);
            }
            for (int partIndex = 0; partIndex < skin.partCount(); ++partIndex) {
                SkinPart part = skin.parts().get(partIndex);
                skinParts.add(part);
            }
            if (skin.paintData() != null) {
                SkinPaintData oldPaintData = skin.paintData();
                if (paintData == null) {
                    paintData = SkinPaintData.v2(oldPaintData.slim());
                }
                for (SkinPartType skinPartType : skin.type().parts()) {
                    if (!(skinPartType instanceof ISkinPartTypeTextured)) continue;
                    ISkinPartTypeTextured texType = (ISkinPartTypeTextured)((Object)skinPartType);
                    this.mergePaintPart(oldPaintData, paintData, texType);
                }
            }
            partIndexs = partIndexs.isEmpty() ? String.valueOf(skinParts.size()) : partIndexs + ":" + skinParts.size();
            for (Map.Entry<String, Object> entry : skin.properties().entrySet()) {
                if (entry.getKey().startsWith("wings")) {
                    properties.put(entry.getKey() + skinIndex, entry.getValue());
                    continue;
                }
                properties.put(entry.getKey(), entry.getValue());
            }
            ++skinIndex;
        }
        if (paintData != null) {
            SkinPaintData resolvedPaintData = SkinPaintData.v1();
            resolvedPaintData.copyFrom(paintData);
            paintData = resolvedPaintData;
        }
        if (!skinParts.isEmpty()) {
            properties.put(SkinProperty.OUTFIT_PART_INDEXS, partIndexs);
            properties.put(SkinProperty.ALL_AUTHOR_NAME, profile.getName());
            if (profile.getId() != null) {
                properties.put(SkinProperty.ALL_AUTHOR_UUID, profile.getId().toString());
            }
            properties.put(SkinProperty.ALL_CUSTOM_NAME, blockEntity.itemName());
            properties.put(SkinProperty.ALL_FLAVOUR_TEXT, blockEntity.itemFlavour());
            Skin.Builder builder = new Skin.Builder(SkinTypes.OUTFIT);
            builder.properties(properties);
            builder.paintData(paintData);
            builder.parts(skinParts);
            Skin skin = builder.build();
            String identifier = SkinLoader.getInstance().saveSkin("", skin);
            SkinDescriptor descriptor = new SkinDescriptor(identifier, skin.type());
            this.setOutputStack(descriptor.asItemStack());
        }
    }

    protected void addInputSlots(IInventory inventory, int start, int end, int x, int y) {
        SkinSlotType[] skinTypes = new SkinSlotType[]{SkinSlotType.HEAD, SkinSlotType.CHEST, SkinSlotType.LEGS, SkinSlotType.FEET, SkinSlotType.WINGS};
        for (int i = start; i < end; ++i) {
            int col = i % 5;
            int row = i / 5;
            this.func_75146_a(new SkinSlot(inventory, i, x + col * 20, y + row * 20, skinTypes));
        }
    }

    protected void addOutputSlot(IInventory inventory, int slot, int x, int y) {
        this.func_75146_a(new Slot(inventory, slot, x, y){});
    }

    protected ItemStack outputStack() {
        Slot outputSlot = (Slot)this.field_75151_b.get(this.field_75151_b.size() - 1);
        return outputSlot.func_75211_c();
    }

    protected void setOutputStack(ItemStack itemStack) {
        Slot outputSlot = (Slot)this.field_75151_b.get(this.field_75151_b.size() - 1);
        outputSlot.func_75215_d(itemStack);
    }

    protected Iterable<ItemStack> inputStacks() {
        return Iterables.transform((Iterable)Iterables.skip((Iterable)Iterables.limit((Iterable)this.field_75151_b, (int)(this.field_75151_b.size() - 1)), (int)36), Slot::func_75211_c);
    }

    private void mergePaintPart(SkinPaintData srcData, SkinPaintData destData, ISkinPartTypeTextured texType) {
        IVector2i pos = texType.textureSkinPos();
        int width = texType.textureModelSize().x() * 2 + texType.textureModelSize().z() * 2;
        int height = texType.textureModelSize().y() + texType.textureModelSize().z();
        for (int ix = 0; ix < width; ++ix) {
            for (int iy = 0; iy < height; ++iy) {
                int y;
                int x = pos.x() + ix;
                int color = srcData.getColor(x, y = pos.y() + iy);
                if (!SkinPaintColor.isOpaque(color)) continue;
                destData.setColor(x, y, color);
            }
        }
    }
}

