/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.UndoStack;
import moe.plushie.armourers_workshop.builder.data.undo.action.ActionRuntimeException;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class UndoActionPacket
extends CustomPacket {
    private final boolean isRedo;

    public UndoActionPacket(IFriendlyByteBuf buffer) {
        this.isRedo = buffer.readBoolean();
    }

    public UndoActionPacket(boolean isRedo) {
        this.isRedo = isRedo;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBoolean(this.isRedo);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        try {
            IFormattableTextComponent message;
            UndoStack stack = UndoManager.of(player.func_110124_au());
            if (this.isRedo) {
                if (!ModPermissions.REDO.accept((PlayerEntity)player)) {
                    return;
                }
                IUserAction command = stack.redo();
                message = TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.redoing", command.name());
            } else {
                if (!ModPermissions.UNDO.accept((PlayerEntity)player)) {
                    return;
                }
                IUserAction command = stack.undo();
                message = TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.undoing", command.name());
            }
            SystemMessageProvider.sendSystemMessage((PlayerEntity)player, (ITextComponent)message);
        }
        catch (ActionRuntimeException exception) {
            SystemMessageProvider.sendSystemMessage((PlayerEntity)player, exception.getComponent());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

