/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.network;

import com.mojang.authlib.GameProfile;
import java.util.function.BiConsumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.common.IEntitySerializer;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.builder.blockentity.ArmourerBlockEntity;
import moe.plushie.armourers_workshop.builder.menu.ArmourerMenu;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.builder.other.CubeChangesCollector;
import moe.plushie.armourers_workshop.builder.other.CubeReplacingEvent;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.player.Player.SystemMessageProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.Constructor;
import moe.plushie.armourers_workshop.core.data.GenericProperties;
import moe.plushie.armourers_workshop.core.data.GenericProperty;
import moe.plushie.armourers_workshop.core.data.GenericValue;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.permission.BlockPermission;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.texture.EntityTextureDescriptor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.ModLog;
import moe.plushie.armourers_workshop.init.ModPermissions;
import moe.plushie.armourers_workshop.utils.DataSerializers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class UpdateArmourerPacket
extends CustomPacket {
    private final BlockPos pos;
    private final GenericValue<ArmourerBlockEntity, ?> fieldValue;

    public UpdateArmourerPacket(IFriendlyByteBuf buffer) {
        this.pos = buffer.readBlockPos();
        this.fieldValue = Field.TYPE.read(buffer);
    }

    public UpdateArmourerPacket(ArmourerBlockEntity entity, GenericValue<ArmourerBlockEntity, ?> fieldValue) {
        this.pos = entity.func_174877_v();
        this.fieldValue = fieldValue;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeBlockPos(this.pos);
        this.fieldValue.write(buffer);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        ArmourerMenu menu1;
        Object object;
        ArmourerBlockEntity blockEntity1;
        block3: {
            block2: {
                TileEntity blockEntity = player.func_71121_q().func_175625_s(this.pos);
                if (!(blockEntity instanceof ArmourerBlockEntity)) break block2;
                blockEntity1 = (ArmourerBlockEntity)blockEntity;
                object = player.field_71070_bA;
                if (!(object instanceof ArmourerMenu)) break block2;
                menu1 = (ArmourerMenu)((Object)object);
                object = this.fieldValue.property();
                if (object instanceof Field) break block3;
            }
            return;
        }
        Field field = (Field)object;
        BlockUtils.performBatch(() -> {
            try {
                field.apply(this, (PlayerEntity)player, blockEntity1, menu1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
    }

    private void loadItem(PlayerEntity player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundNBT nbt) {
        container.loadArmourItem(player);
    }

    private void saveItem(PlayerEntity player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundNBT nbt) {
        ModLog.info("accept save action of the {}, nbt: {}", player.func_195047_I_(), nbt);
        GameProfile profile = DataSerializers.readGameProfile(nbt);
        container.saveArmourItem(player, profile, null, null);
    }

    private void copyItem(PlayerEntity player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundNBT nbt) throws Exception {
        ModLog.info("accept copy action of the {}, nbt: {}", player.func_195047_I_(), nbt);
        Boolean isMirror = OptionalAPI.getOptionalBoolean(nbt, "Mirror").orElse(false);
        Boolean isCopyPaintData = OptionalAPI.getOptionalBoolean(nbt, "Paints").orElse(false);
        SkinPartType sourcePartType = SkinPartTypes.byName(OptionalAPI.getOptionalString(nbt, "Source").orElse(""));
        SkinPartType destinationPartType = SkinPartTypes.byName(OptionalAPI.getOptionalString(nbt, "Destination").orElse(""));
        CubeChangesCollector collector = new CubeChangesCollector(blockEntity.func_145831_w());
        blockEntity.copyCubes(collector, sourcePartType, destinationPartType, isMirror);
        if (isCopyPaintData.booleanValue()) {
            blockEntity.copyPaintData(collector, sourcePartType, destinationPartType, isMirror);
        }
        collector.submit((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "action.armourers_workshop.block.copy", new Object[0]), player);
    }

    private void replaceItem(PlayerEntity player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundNBT nbt) throws Exception {
        ModLog.info("accept replace action of the {}, nbt: {}", player.func_195047_I_(), nbt);
        World level = PropertyProvider.getLevel((Entity)player);
        ItemStack source = OptionalAPI.getOptionalCompound(nbt, "Source").flatMap(tag -> Constructor.parse(ItemStack.class, level.func_241828_r(), tag)).orElse(ItemStack.field_190927_a);
        ItemStack destination = OptionalAPI.getOptionalCompound(nbt, "Destination").flatMap(tag -> Constructor.parse(ItemStack.class, level.func_241828_r(), tag)).orElse(ItemStack.field_190927_a);
        CubeReplacingEvent event = new CubeReplacingEvent(source, destination);
        event.keepColor = OptionalAPI.getOptionalBoolean(nbt, "KeepColor").orElse(false);
        event.keepPaintType = OptionalAPI.getOptionalBoolean(nbt, "KeepPaintType").orElse(false);
        if (event.isEmptySource && event.isEmptyDestination) {
            return;
        }
        CubeChangesCollector collector = new CubeChangesCollector(blockEntity.func_145831_w());
        blockEntity.replaceCubes(collector, SkinPartTypes.UNKNOWN, event);
        collector.submit((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "action.armourers_workshop.block.replace", new Object[0]), player);
        SystemMessageProvider.sendSystemMessage(player, (ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "inventory.armourers_workshop.armourer.dialog.replace.success", collector.total()));
    }

    private void clearItem(PlayerEntity player, ArmourerBlockEntity blockEntity, ArmourerMenu container, CompoundNBT nbt) {
        ModLog.info("accept clear action of the {}, nbt: {}", player.func_195047_I_(), nbt);
        CubeChangesCollector collector = new CubeChangesCollector(blockEntity.func_145831_w());
        SkinPartType partType = OptionalAPI.getOptionalString(nbt, "PartType").map(SkinPartTypes::byName).orElse(SkinPartTypes.UNKNOWN);
        if (OptionalAPI.getOptionalBoolean(nbt, "Cubes").orElse(false).booleanValue()) {
            blockEntity.clearCubes(collector, partType);
        }
        if (OptionalAPI.getOptionalBoolean(nbt, "Paints").orElse(false).booleanValue()) {
            blockEntity.clearPaintData(collector, partType);
        }
        if (OptionalAPI.getOptionalBoolean(nbt, "Markers").orElse(false).booleanValue() && !OptionalAPI.getOptionalBoolean(nbt, "Cubes").orElse(false).booleanValue()) {
            blockEntity.clearMarkers(collector, partType);
        }
        collector.submit((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "action.armourers_workshop.block.clear", new Object[0]), player);
    }

    public static final class Field<T>
    extends GenericProperty<ArmourerBlockEntity, T> {
        private static final GenericProperties<ArmourerBlockEntity> TYPE = GenericProperties.of(ArmourerBlockEntity.class, UpdateArmourerPacket::new);
        public static final Field<Integer> FLAGS = Field.create(ArmourerBlockEntity::getFlags, ArmourerBlockEntity::setFlags, DataSerializers.INT, ModPermissions.ARMOURER_SETTING);
        public static final Field<SkinType> SKIN_TYPE = Field.create(ArmourerBlockEntity::skinType, ArmourerBlockEntity::setSkinType, DataSerializers.SKIN_TYPE, ModPermissions.ARMOURER_SETTING);
        public static final Field<SkinProperties> SKIN_PROPERTIES = Field.create(ArmourerBlockEntity::skinProperties, ArmourerBlockEntity::setSkinProperties, DataSerializers.SKIN_PROPERTIES, ModPermissions.ARMOURER_SETTING);
        public static final Field<EntityTextureDescriptor> TEXTURE_DESCRIPTOR = Field.create(ArmourerBlockEntity::textureDescriptor, ArmourerBlockEntity::setTextureDescriptor, DataSerializers.PLAYER_TEXTURE, ModPermissions.ARMOURER_SETTING);
        public static final Field<EntityTextureDescriptor.Model> TEXTURE_MODEL = Field.create(ArmourerBlockEntity::textureModel, ArmourerBlockEntity::setTextureModel, DataSerializers.PLAYER_TEXTURE_MODEL, ModPermissions.ARMOURER_SETTING);
        public static final Field<CompoundNBT> ITEM_CLEAR = Field.create((rec$, x$0, x$1, x$2, x$3) -> UpdateArmourerPacket.access$600(rec$, x$0, x$1, x$2, x$3), DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_CLEAR);
        public static final Field<CompoundNBT> ITEM_COPY = Field.create((rec$, x$0, x$1, x$2, x$3) -> UpdateArmourerPacket.access$500(rec$, x$0, x$1, x$2, x$3), DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_COPY);
        public static final Field<CompoundNBT> ITEM_REPLACE = Field.create((rec$, x$0, x$1, x$2, x$3) -> UpdateArmourerPacket.access$400(rec$, x$0, x$1, x$2, x$3), DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_REPLACE);
        public static final Field<CompoundNBT> ITEM_LOAD = Field.create((rec$, x$0, x$1, x$2, x$3) -> UpdateArmourerPacket.access$300(rec$, x$0, x$1, x$2, x$3), DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_LOAD);
        public static final Field<CompoundNBT> ITEM_SAVE = Field.create((rec$, x$0, x$1, x$2, x$3) -> UpdateArmourerPacket.access$200(rec$, x$0, x$1, x$2, x$3), DataSerializers.COMPOUND_TAG, ModPermissions.ARMOURER_SAVE);
        private FieldAction<T> action;
        private BlockPermission permission;

        private static <T> Field<T> create(FieldAction<T> action, IEntitySerializer<T> dataSerializer, BlockPermission permission) {
            Field field = TYPE.create(dataSerializer).build(Field::new);
            field.action = action;
            field.permission = permission;
            return field;
        }

        private static <T> Field<T> create(Function<ArmourerBlockEntity, T> supplier, BiConsumer<ArmourerBlockEntity, T> applier, IEntitySerializer<T> dataSerializer, BlockPermission permission) {
            Field field = TYPE.create(dataSerializer).getter(supplier).setter(applier).build(Field::new);
            field.permission = permission;
            return field;
        }

        private void apply(UpdateArmourerPacket packet, PlayerEntity player, ArmourerBlockEntity blockEntity, ArmourerMenu container) throws Exception {
            if (!this.permission.accept(blockEntity, player)) {
                return;
            }
            if (this.action != null) {
                Object value = Objects.unsafeCast(packet.fieldValue.value());
                this.action.accept(packet, player, blockEntity, container, value);
            } else {
                packet.fieldValue.apply(blockEntity);
            }
        }
    }

    public static interface FieldAction<T> {
        public void accept(UpdateArmourerPacket var1, PlayerEntity var2, ArmourerBlockEntity var3, ArmourerMenu var4, T var5) throws Exception;
    }
}

