/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import moe.plushie.armourers_workshop.api.common.IBlockSnapshot;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.builder.data.undo.UndoManager;
import moe.plushie.armourers_workshop.builder.data.undo.action.NamedUserAction;
import moe.plushie.armourers_workshop.builder.data.undo.action.SetBlockAction;
import moe.plushie.armourers_workshop.compatibility.core.AbstractDirection;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.init.ModBlocks;
import moe.plushie.armourers_workshop.init.event.common.BlockEvent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public final class BlockUtils {
    private static final Set<IRegistryHolder<Block>> SNAPSHOT_BLOCKS = Collections.immutableSet(it -> {
        it.add(ModBlocks.SKIN_CUBE);
        it.add(ModBlocks.SKIN_CUBE_GLASS);
        it.add(ModBlocks.SKIN_CUBE_GLASS_GLOWING);
        it.add(ModBlocks.SKIN_CUBE_GLOWING);
        it.add(ModBlocks.ADVANCED_SKIN_BUILDER);
    });
    private static final ThreadLocal<Map<TileEntity, Runnable>> SNAPSHOT_QUEUE = ThreadLocal.withInitial(() -> null);

    public static void beginCombiner() {
        Map<TileEntity, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            SNAPSHOT_QUEUE.set(new IdentityHashMap());
        }
    }

    public static <T extends TileEntity> void combine(T blockEntity, Runnable handler) {
        Map<TileEntity, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            handler.run();
            blockEntity.func_70296_d();
            return;
        }
        queue.put(blockEntity, handler);
    }

    public static void snapshot(BlockEvent event) {
        ServerPlayerEntity player;
        Entity entity;
        block5: {
            block4: {
                entity = event.entity();
                if (!(entity instanceof ServerPlayerEntity)) break block4;
                player = (ServerPlayerEntity)entity;
                entity = event.level();
                if (entity instanceof World) break block5;
            }
            return;
        }
        World level = (World)entity;
        ActionType actionType = ActionType.of(event);
        if (actionType == null) {
            return;
        }
        IBlockSnapshot snapshot = event.snapshot();
        NamedUserAction group = new NamedUserAction(actionType.title());
        group.push(new SetBlockAction(level, event.blockPos(), snapshot.state(), snapshot.tag()));
        UndoManager.of(player.func_110124_au()).push(group);
    }

    public static void endCombiner() {
        Map<TileEntity, Runnable> queue = SNAPSHOT_QUEUE.get();
        if (queue == null) {
            return;
        }
        queue.forEach((k, v) -> {
            v.run();
            k.func_70296_d();
        });
        SNAPSHOT_QUEUE.remove();
    }

    public static void performBatch(Runnable handler) {
        try {
            BlockUtils.beginCombiner();
            handler.run();
        }
        finally {
            BlockUtils.endCombiner();
        }
    }

    public static ArrayList<BlockPos> findTouchingBlockFaces(World level, BlockPos pos, OpenDirection facing, int radius, boolean restrictPlane) {
        ArrayList<BlockPos> blockFaces = new ArrayList<BlockPos>();
        ArrayList<BlockPos> openList = new ArrayList<BlockPos>();
        HashSet<BlockPos> closedList = new HashSet<BlockPos>();
        BlockPos startPos = pos.func_177972_a(AbstractDirection.unwrap(facing));
        openList.add(startPos);
        OpenDirection[] sides = OpenDirection.values();
        boolean first = true;
        while (!openList.isEmpty()) {
            BlockPos loc = (BlockPos)openList.remove(0);
            TileEntity blockEntity = level.func_175625_s(loc);
            if (blockEntity instanceof IBlockPaintable) {
                if (!restrictPlane) {
                    blockFaces.add(loc);
                } else if (BlockUtils.samePlane(loc, pos, facing)) {
                    blockFaces.add(loc);
                }
            }
            for (OpenDirection side : sides) {
                BlockPos sideLoc = loc.func_177972_a(AbstractDirection.unwrap(side));
                if (closedList.contains(sideLoc)) continue;
                closedList.add(sideLoc);
                if (!(BlockUtils.getDistance(sideLoc, pos) < (double)radius & BlockUtils.hasPaintableBlock(level, sideLoc))) continue;
                openList.add(sideLoc);
            }
            if (closedList.size() <= 5000) continue;
            break;
        }
        return blockFaces;
    }

    public static double getDistance(BlockPos src, BlockPos dst) {
        double d0 = src.func_177958_n() - dst.func_177958_n();
        double d1 = src.func_177956_o() - dst.func_177956_o();
        double d2 = src.func_177952_p() - dst.func_177952_p();
        return Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
    }

    private static boolean hasPaintableBlock(World level, BlockPos pos) {
        for (int ix = 0; ix < 3; ++ix) {
            for (int iy = 0; iy < 3; ++iy) {
                for (int iz = 0; iz < 3; ++iz) {
                    TileEntity stateValid = level.func_175625_s(pos.func_177982_a(ix - 1, iy - 1, iz - 1));
                    if (!(stateValid instanceof IBlockPaintable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean samePlane(BlockPos src, BlockPos dst, OpenDirection direction) {
        if (!(direction.stepX() != 0 && src.func_177958_n() != dst.func_177958_n() || direction.stepY() != 0 && src.func_177956_o() != dst.func_177956_o())) {
            return direction.stepZ() == 0 || src.func_177952_p() == dst.func_177952_p();
        }
        return false;
    }

    private static boolean isSnapshotBlock(Block block) {
        return SNAPSHOT_BLOCKS.stream().anyMatch(it -> it.get() == block);
    }

    public static class ActionType {
        private final ITextComponent title;

        private ActionType(ITextComponent title) {
            this.title = title;
        }

        public static ActionType of(BlockEvent event) {
            BlockState blockState = event.blockState();
            if (blockState != null && BlockUtils.isSnapshotBlock(blockState.func_177230_c())) {
                return new ActionType((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.placeBlock", new Object[0]));
            }
            IBlockSnapshot snapshot = event.snapshot();
            if (blockState == null && BlockUtils.isSnapshotBlock(snapshot.state().func_177230_c())) {
                return new ActionType((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.breakBlock", new Object[0]));
            }
            return null;
        }

        public ITextComponent title() {
            return this.title;
        }
    }
}

