/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.HashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.action.IUserAction;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.builder.data.undo.action.ActionRuntimeException;
import moe.plushie.armourers_workshop.builder.other.WorldUpdater;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.network.chat.Component.TranslatableProvider;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import moe.plushie.armourers_workshop.core.data.paint.IBlockPaintable;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintColor;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class CubeChanges
implements IUserAction,
IWorldUpdateTask {
    private final World level;
    private final BlockPos blockPos;
    private BlockState blockState;
    private CompoundNBT nbt;
    private Map<OpenDirection, SkinPaintColor> colors;

    public CubeChanges(World level, BlockPos blockPos) {
        this.level = level;
        this.blockPos = blockPos;
    }

    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
    }

    public void setCompoundTag(CompoundNBT nbt) {
        this.nbt = nbt;
    }

    public void setColor(OpenDirection dir, SkinPaintColor color) {
        if (this.colors == null) {
            this.colors = new HashMap<OpenDirection, SkinPaintColor>();
        }
        this.colors.put(dir, color);
    }

    public void setColors(Map<OpenDirection, SkinPaintColor> colors) {
        this.colors = colors;
    }

    @Override
    public BlockPos blockPos() {
        return this.blockPos;
    }

    @Override
    public BlockState blockState() {
        return this.blockState;
    }

    private boolean isChangeNBT() {
        return this.nbt != null || this.colors != null;
    }

    @Override
    public void prepare() throws RuntimeException {
        if (!this.isChangeNBT()) {
            return;
        }
        if (this.blockState != null) {
            return;
        }
        TileEntity blockEntity = this.level.func_175625_s(this.blockPos);
        if (blockEntity == null) {
            String value = String.format("x=%d, y=%d, z=%d", this.blockPos.func_177958_n(), this.blockPos.func_177956_o(), this.blockPos.func_177952_p());
            throw new ActionRuntimeException((ITextComponent)TranslatableProvider.translatable(ITextComponent.class, "chat.armourers_workshop.undo.missingBlock", value));
        }
    }

    @Override
    public IUserAction apply() throws RuntimeException {
        TileEntity blockEntity2;
        boolean isChangedNBT = false;
        CubeChanges changes = new CubeChanges(this.level, this.blockPos);
        if (this.blockState != null) {
            changes.setBlockState(this.level.func_180495_p(this.blockPos));
            isChangedNBT = true;
        }
        if (this.nbt != null) {
            isChangedNBT = true;
        }
        if (isChangedNBT) {
            Objects.flatMap(this.level.func_175625_s(this.blockPos), blockEntity -> {
                CompoundNBT newTag = StorageAPI.saveFullData(blockEntity, this.level.func_241828_r());
                changes.setCompoundTag(newTag);
                return newTag;
            });
        } else if (this.colors != null && (blockEntity2 = this.level.func_175625_s(this.blockPos)) instanceof IBlockPaintable) {
            IBlockPaintable target = (IBlockPaintable)blockEntity2;
            HashMap<OpenDirection, SkinPaintColor> oldValue = new HashMap<OpenDirection, SkinPaintColor>();
            for (OpenDirection direction : this.colors.keySet()) {
                SkinPaintColor paintColor = target.getColor(direction);
                if (paintColor == null) {
                    paintColor = SkinPaintColor.CLEAR;
                }
                oldValue.put(direction, paintColor);
            }
            changes.setColors(oldValue);
        }
        WorldUpdater.getInstance().submit(this);
        return changes;
    }

    @Override
    public World level() {
        return this.level;
    }

    @Override
    public ActionResultType run(World level) {
        if (!level.func_195588_v(this.blockPos)) {
            return ActionResultType.PASS;
        }
        int changes = 0;
        if (this.blockState != null && !this.blockState.equals(level.func_180495_p(this.blockPos))) {
            level.func_180501_a(this.blockPos, this.blockState, 3);
            ++changes;
        }
        TileEntity blockEntity = null;
        if (this.isChangeNBT()) {
            blockEntity = level.func_175625_s(this.blockPos);
        }
        if (this.nbt != null && blockEntity != null) {
            StorageAPI.loadFullData(blockEntity, this.nbt, level.func_241828_r());
            ++changes;
        }
        if (this.colors != null && blockEntity instanceof IBlockPaintable) {
            IBlockPaintable paintable = (IBlockPaintable)blockEntity;
            paintable.setColors(this.colors);
            ++changes;
        }
        if (changes == 0) {
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }
}

