/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import moe.plushie.armourers_workshop.core.math.OpenMath;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.utils.OpenDirection;
import moe.plushie.armourers_workshop.core.utils.OpenRotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CubeTransform {
    public final World level;
    public final BlockPos blockPos;
    public final OpenDirection direction;
    public final OpenRotation rotation;
    public final OpenRotation invRotation;
    public final OpenQuaternionf rotationDegrees;

    public CubeTransform(World level, BlockPos blockPos, OpenDirection direction) {
        this.level = level;
        this.blockPos = blockPos;
        this.direction = direction;
        this.rotation = CubeTransform.getRotation(direction, false);
        this.invRotation = CubeTransform.getRotation(direction, true);
        this.rotationDegrees = CubeTransform.getRotationDegrees(direction);
    }

    public static OpenRotation getRotation(OpenDirection dir, boolean flags) {
        OpenRotation openRotation;
        switch (dir) {
            case SOUTH: {
                openRotation = OpenRotation.CLOCKWISE_180;
                break;
            }
            case WEST: {
                if (flags) {
                    openRotation = OpenRotation.CLOCKWISE_90;
                    break;
                }
                openRotation = OpenRotation.COUNTERCLOCKWISE_90;
                break;
            }
            case EAST: {
                if (flags) {
                    openRotation = OpenRotation.COUNTERCLOCKWISE_90;
                    break;
                }
                openRotation = OpenRotation.CLOCKWISE_90;
                break;
            }
            default: {
                openRotation = OpenRotation.NONE;
            }
        }
        return openRotation;
    }

    public static OpenQuaternionf getRotationDegrees(OpenDirection dir) {
        OpenQuaternionf openQuaternionf;
        switch (dir) {
            case SOUTH: {
                openQuaternionf = new OpenQuaternionf(0.0f, 180.0f, 0.0f, true);
                break;
            }
            case WEST: {
                openQuaternionf = new OpenQuaternionf(0.0f, 90.0f, 0.0f, true);
                break;
            }
            case EAST: {
                openQuaternionf = new OpenQuaternionf(0.0f, -90.0f, 0.0f, true);
                break;
            }
            default: {
                openQuaternionf = OpenQuaternionf.ONE;
            }
        }
        return openQuaternionf;
    }

    public OpenDirection rotate(OpenDirection dir) {
        return this.rotation.rotate(dir);
    }

    public OpenDirection invRotate(OpenDirection dir) {
        return this.invRotation.rotate(dir);
    }

    public BlockPos mul(OpenVector3i pos) {
        return this.mul(pos.x(), pos.y(), pos.z());
    }

    public BlockPos mul(int x, int y, int z) {
        if (this.rotationDegrees == OpenQuaternionf.ONE) {
            return this.blockPos.func_177982_a(x, y, z);
        }
        OpenVector4f off = new OpenVector4f((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, 1.0f);
        off.transform(this.rotationDegrees);
        return this.blockPos.func_177982_a(OpenMath.floori(off.x()), OpenMath.floori(off.y()), OpenMath.floori(off.z()));
    }
}

