/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.function.Consumer;
import java.util.function.Predicate;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.level.block.entity.BlockEntity.StorageAPI;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldBlockUpdateTask
implements IWorldUpdateTask {
    World level;
    BlockPos blockPos;
    BlockState blockState;
    CompoundNBT nbt;
    Predicate<BlockState> validator;
    Consumer<BlockState> modifier;
    private int blockFlags = 3;

    public WorldBlockUpdateTask(World level, BlockPos blockPos, BlockState blockState) {
        this(level, blockPos, blockState, null);
    }

    public WorldBlockUpdateTask(World level, BlockPos blockPos, BlockState blockState, CompoundNBT nbt) {
        this.level = level;
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.nbt = nbt;
    }

    public void setValidator(Predicate<BlockState> validator) {
        this.validator = validator;
    }

    public void setModifier(Consumer<BlockState> modifier) {
        this.modifier = modifier;
    }

    public void setBlockFlags(int blockFlags) {
        this.blockFlags = blockFlags;
    }

    @Override
    public World level() {
        return this.level;
    }

    @Override
    public BlockPos blockPos() {
        return this.blockPos;
    }

    @Override
    public BlockState blockState() {
        return this.blockState;
    }

    @Override
    public ActionResultType run(World level) {
        TileEntity blockEntity;
        if (!level.func_195588_v(this.blockPos)) {
            return ActionResultType.PASS;
        }
        if (this.validator != null && !this.validator.test(level.func_180495_p(this.blockPos))) {
            return ActionResultType.PASS;
        }
        level.func_180501_a(this.blockPos, this.blockState, this.blockFlags);
        if (this.nbt != null && (blockEntity = level.func_175625_s(this.blockPos)) != null) {
            StorageAPI.loadFullData(blockEntity, this.nbt, level.func_241828_r());
        }
        if (this.modifier != null) {
            this.modifier.accept(this.blockState);
        }
        return ActionResultType.SUCCESS;
    }
}

