/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.builder.other;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import moe.plushie.armourers_workshop.api.common.IWorldUpdateTask;
import moe.plushie.armourers_workshop.builder.other.BlockUtils;
import moe.plushie.armourers_workshop.init.ModConfig;
import net.minecraft.block.BlockState;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public class WorldUpdater {
    private static final WorldUpdater INSTANCE = new WorldUpdater();
    private final LinkedList<IWorldUpdateTask> failedTasks = new LinkedList();
    private final HashMap<RegistryKey<World>, AutoMergeQueue> allTasks = new HashMap();

    public static WorldUpdater getInstance() {
        return INSTANCE;
    }

    public synchronized void submit(IWorldUpdateTask task) {
        this.allTasks.computeIfAbsent((RegistryKey<World>)task.level().func_234923_W_(), k -> new AutoMergeQueue()).push(task);
    }

    public void tick(World level) {
        RegistryKey key = level.func_234923_W_();
        if (this.isEmpty((RegistryKey<World>)key)) {
            return;
        }
        BlockUtils.performBatch(() -> {
            IWorldUpdateTask task;
            int count = ModConfig.Common.blockTaskRate;
            while (count > 0 && (task = this.poll((RegistryKey<World>)key)) != null) {
                ActionResultType resultType = task.run(level);
                if (resultType.func_226246_a_()) {
                    --count;
                    continue;
                }
                if (resultType != ActionResultType.FAIL) continue;
                this.failedTasks.add(task);
            }
            if (!this.failedTasks.isEmpty()) {
                this.failedTasks.forEach(this::submit);
                this.failedTasks.clear();
            }
        });
    }

    public synchronized void drain(World level) {
        AutoMergeQueue queue = this.allTasks.remove(level.func_234923_W_());
        if (queue == null || queue.isEmpty()) {
            return;
        }
        BlockUtils.performBatch(() -> {
            while (!queue.isEmpty()) {
                queue.pop().run(level);
            }
        });
    }

    public synchronized boolean isEmpty(RegistryKey<World> key) {
        AutoMergeQueue m = this.allTasks.get(key);
        return m == null || m.isEmpty();
    }

    @Nullable
    public synchronized IWorldUpdateTask poll(RegistryKey<World> key) {
        AutoMergeQueue m = this.allTasks.get(key);
        if (m != null && !m.isEmpty()) {
            return m.pop();
        }
        return null;
    }

    public static class AutoMergeQueue {
        private final HashMap<BlockPos, IWorldUpdateTask> fastTable = new HashMap();
        private final ArrayList<IWorldUpdateTask> tasks = new ArrayList();

        public void push(IWorldUpdateTask task) {
            BlockPos blockPos = task.blockPos();
            IWorldUpdateTask pendingTask = this.fastTable.get(blockPos);
            if (pendingTask == null) {
                this.tasks.add(task);
                this.fastTable.put(blockPos, task);
                return;
            }
            if (pendingTask instanceof AutoMergeTask) {
                AutoMergeTask mergeTask = (AutoMergeTask)pendingTask;
                mergeTask.add(task);
                return;
            }
            AutoMergeTask mergedTask = new AutoMergeTask(pendingTask);
            mergedTask.add(task);
            this.fastTable.put(blockPos, mergedTask);
        }

        public IWorldUpdateTask pop() {
            IWorldUpdateTask task = this.tasks.remove(0);
            IWorldUpdateTask mergedTask = this.fastTable.remove(task.blockPos());
            if (mergedTask != null) {
                return mergedTask;
            }
            return task;
        }

        public boolean isEmpty() {
            return this.tasks.isEmpty();
        }
    }

    public static class AutoMergeTask
    implements IWorldUpdateTask {
        private final World level;
        private final BlockPos blockPos;
        private final ArrayList<IWorldUpdateTask> tasks = new ArrayList();

        public AutoMergeTask(IWorldUpdateTask task) {
            this.level = task.level();
            this.blockPos = task.blockPos();
            this.tasks.add(task);
        }

        public void add(IWorldUpdateTask task) {
            this.tasks.add(task);
        }

        public void optimize(World level) {
            ArrayList<IWorldUpdateTask> optimizedTasks = new ArrayList<IWorldUpdateTask>();
            BlockState lastBlockState = null;
            for (IWorldUpdateTask task : this.tasks) {
                BlockState newBlockState = task.blockState();
                if (!Objects.equals(newBlockState, lastBlockState)) {
                    lastBlockState = newBlockState;
                    optimizedTasks.clear();
                }
                optimizedTasks.add(task);
            }
            if (this.tasks.size() != optimizedTasks.size()) {
                this.tasks.clear();
                this.tasks.addAll(optimizedTasks);
            }
        }

        @Override
        public World level() {
            return this.level;
        }

        @Override
        public BlockPos blockPos() {
            return this.blockPos;
        }

        @Override
        public BlockState blockState() {
            return null;
        }

        @Override
        public ActionResultType run(World level) {
            this.optimize(level);
            int changes = 0;
            ArrayList<IWorldUpdateTask> failedTasks = new ArrayList<IWorldUpdateTask>();
            for (IWorldUpdateTask task : this.tasks) {
                ActionResultType resultType = task.run(level);
                if (resultType.func_226246_a_()) {
                    ++changes;
                }
                if (resultType != ActionResultType.FAIL) continue;
                failedTasks.add(task);
            }
            if (!failedTasks.isEmpty()) {
                this.tasks.clear();
                this.tasks.addAll(failedTasks);
                return ActionResultType.FAIL;
            }
            if (changes != 0) {
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        }
    }
}

