/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.google.common.collect.ImmutableList;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IRenderedBuffer;
import moe.plushie.armourers_workshop.api.client.IVertexFormat;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferBuilder;
import moe.plushie.armourers_workshop.compatibility.client.AbstractRenderType;
import moe.plushie.armourers_workshop.core.client.other.VertexBufferObject;
import moe.plushie.armourers_workshop.core.data.cache.SkinCache;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class AbstractColorBufferObject
extends VertexBufferObject {
    public static final IRenderType TYPE = AbstractRenderType.of((RenderType)RenderType.func_228633_a_((String)"", (VertexFormat)AbstractColorBufferObject.createDefaultFormat(), (int)7, (int)256, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228728_a_(false)));
    public static final int PAGE_SIZE = 4096;
    private static final SkinCache.LRU<Integer, AbstractColorBufferObject> SHARED_COLORS = new SkinCache.LRU();
    private final int color;
    private int capacity;

    public AbstractColorBufferObject(int color) {
        this.color = color;
        this.capacity = 0;
    }

    @NotNull
    public static AbstractColorBufferObject getColorBuffer(int color) {
        return SHARED_COLORS.computeIfAbsent(color, AbstractColorBufferObject::new);
    }

    private static VertexFormat createDefaultFormat() {
        return new VertexFormat(ImmutableList.of((Object)DefaultVertexFormats.field_181714_n));
    }

    public void ensureCapacity(int capacity) {
        if (capacity <= this.capacity) {
            return;
        }
        int alignedCapacity = (capacity / 4096 + 1) * 4096;
        AbstractBufferBuilder builder = new AbstractBufferBuilder(alignedCapacity * this.format().vertexSize());
        builder.begin(TYPE);
        for (int i = 0; i < alignedCapacity; ++i) {
            builder.color(this.color).endVertex();
        }
        IRenderedBuffer renderedBuffer = builder.end();
        this.upload(renderedBuffer.vertexBuffer());
        this.capacity = alignedCapacity;
        renderedBuffer.release();
    }

    public IVertexFormat format() {
        return TYPE.format();
    }
}

