/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.client;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import moe.plushie.armourers_workshop.core.utils.Executors;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AbstractCustomProfileTextureLoader {
    public static void load(GameProfile profile, ResultHandler handler) {
        int timeout = 30000;
        AbstractCustomProfileTextureLoader.load(profile, System.currentTimeMillis() + (long)timeout, handler);
    }

    private static void load(GameProfile profile, long endTime, ResultHandler handler) {
        Minecraft.func_71410_x().func_152342_ad().func_152790_a(profile, (type, location, profileTexture) -> {
            if (type != MinecraftProfileTexture.Type.SKIN) {
                return;
            }
            String url = profileTexture.getUrl();
            if (url == null && System.currentTimeMillis() < endTime) {
                Executors.sleep(500L);
                AbstractCustomProfileTextureLoader.load(profile, endTime, handler);
                return;
            }
            String modelType = profileTexture.getMetadata("model");
            handler.accept(OpenResourceLocation.create(location), url, modelType);
        }, true);
    }

    public static interface ResultHandler {
        public void accept(OpenResourceLocation var1, String var2, String var3);
    }
}

