/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core;

import java.util.Optional;
import moe.plushie.armourers_workshop.api.common.IGlobalPos;
import moe.plushie.armourers_workshop.api.common.IMenuType;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.core.utils.TranslateUtils;
import moe.plushie.armourers_workshop.init.ModPermissions;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public abstract class AbstractMenuType<C extends Container>
implements IMenuType<C> {
    private IResourceLocation registryName;

    @Override
    public <T> ActionResultType openMenu(PlayerEntity player, T value) {
        if (player == null || value == null) {
            return ActionResultType.FAIL;
        }
        if (!(player instanceof ServerPlayerEntity)) {
            return ActionResultType.CONSUME;
        }
        ServerPlayerEntity serverPlayer = (ServerPlayerEntity)player;
        IGlobalPos globalPos = this.getGlobalPos(value);
        if (globalPos != null) {
            return this.openMenu(serverPlayer, globalPos, null).orElse(ActionResultType.FAIL);
        }
        return this.openMenu(serverPlayer, this.title(), value);
    }

    protected Optional<ActionResultType> openMenu(ServerPlayerEntity player, IGlobalPos globalPos, Object extraData) {
        return globalPos.evaluate((level, blockPos) -> {
            if (!ModPermissions.OPEN.accept(this, (World)level, (BlockPos)blockPos, (PlayerEntity)player)) {
                return ActionResultType.FAIL;
            }
            return this.openMenu(player, this.title(), globalPos);
        });
    }

    protected abstract <T> ActionResultType openMenu(ServerPlayerEntity var1, ITextComponent var2, T var3);

    protected <T> IGlobalPos getGlobalPos(T value) {
        if (value instanceof IGlobalPos) {
            IGlobalPos globalPos = (IGlobalPos)value;
            return globalPos;
        }
        if (value instanceof TileEntity) {
            TileEntity blockEntity = (TileEntity)value;
            return IGlobalPos.create(blockEntity.func_145831_w(), blockEntity.func_174877_v());
        }
        return null;
    }

    @Override
    public ITextComponent title() {
        return TranslateUtils.title("inventory.armourers_workshop." + this.registryName().path(), new Object[0]);
    }

    @Override
    public IResourceLocation registryName() {
        return this.registryName;
    }

    public void setRegistryName(IResourceLocation registryName) {
        this.registryName = registryName;
    }
}

