/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.core.data;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import org.jetbrains.annotations.Nullable;

public class AbstractDataComponentType<T>
implements IDataComponentType<T> {
    private final String name;
    private final IDataCodec<T> codec;

    public AbstractDataComponentType(String name, IDataCodec<T> codec) {
        this.name = name;
        this.codec = codec;
    }

    public static <T> AbstractDataComponentType<T> create(String name, IDataCodec<T> codec) {
        return new AbstractDataComponentType<T>(name, codec);
    }

    public boolean isProxy() {
        return false;
    }

    @Override
    public boolean has(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        return tag != null && tag.func_74764_b(this.name);
    }

    @Override
    public void set(ItemStack itemStack, @Nullable T value) {
        if (value != null) {
            CompoundNBT tag = itemStack.func_196082_o();
            this.codec.codec().encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, value).get().ifLeft(it -> tag.func_218657_a(this.name, it));
        } else {
            this.remove(itemStack);
        }
    }

    @Override
    @Nullable
    public T get(ItemStack itemStack) {
        Optional value;
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag != null && tag.func_74764_b(this.name) && (value = this.codec.codec().decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag.func_74781_a(this.name)).get().left()).isPresent()) {
            return (T)((Pair)value.get()).getFirst();
        }
        return null;
    }

    @Override
    public T getOrDefault(ItemStack itemStack, T defaultValue) {
        T value = this.get(itemStack);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public void remove(ItemStack itemStack) {
        CompoundNBT tag = itemStack.func_77978_p();
        if (tag != null) {
            tag.func_82580_o(this.name);
        }
    }
}

