/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IPacketDistributor;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.core.data.AbstractFriendlyByteBuf;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.platform.NetworkManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSidedProvider;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.event.EventNetworkChannel;
import org.apache.commons.lang3.tuple.Pair;

public class AbstractForgeNetwork {

    public static class Distributors
    implements NetworkManager.Distributors {
        @Override
        public IPacketDistributor trackingChunk(Supplier<Chunk> supplier) {
            return new Distributor(PacketDistributor.TRACKING_CHUNK.with(supplier), null);
        }

        @Override
        public IPacketDistributor trackingEntityAndSelf(Supplier<Entity> supplier) {
            return new Distributor(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(supplier), null);
        }

        @Override
        public IPacketDistributor player(Supplier<ServerPlayerEntity> supplier) {
            return new Distributor(PacketDistributor.PLAYER.with(supplier), null);
        }

        @Override
        public IPacketDistributor allPlayers() {
            return new Distributor(PacketDistributor.ALL.noArg(), null);
        }

        @Override
        public IPacketDistributor server() {
            return new Distributor(PacketDistributor.SERVER.noArg(), null);
        }
    }

    public static class Distributor
    implements IPacketDistributor {
        private final PacketDistributor.PacketTarget target;
        private final IPacket<?> packet;

        Distributor(PacketDistributor.PacketTarget target, IPacket<?> packet) {
            this.target = target;
            this.packet = packet;
        }

        @Override
        public IPacketDistributor add(IResourceLocation channel, IFriendlyByteBuf buf) {
            NetworkDirection direction = this.target.getDirection();
            PacketBuffer buf1 = (PacketBuffer)buf.asByteBuf();
            IPacket packet1 = direction.buildPacket(Pair.of((Object)buf1, (Object)0), channel.toLocation()).getThis();
            return new Distributor(this.target, packet1);
        }

        @Override
        public void execute() {
            if (this.packet == null) {
                return;
            }
            NetworkDirection direction = this.target.getDirection();
            ThreadTaskExecutor executor = (ThreadTaskExecutor)LogicalSidedProvider.WORKQUEUE.get(direction.getOriginationSide());
            executor.func_213165_a(() -> this.target.send(this.packet));
        }

        @Override
        public boolean isClientbound() {
            return this.target.getDirection() == NetworkDirection.PLAY_TO_CLIENT;
        }
    }

    public static class Dispatcher
    extends NetworkManager.Dispatcher {
        public Dispatcher(IResourceLocation channelName, String channelVersion) {
            super(channelName, channelVersion);
        }

        @Override
        public void register() {
            EventNetworkChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)this.channelName.toLocation()).networkProtocolVersion(() -> this.channelVersion).clientAcceptedVersions(sv -> true).serverAcceptedVersions(cv -> {
                if (ModConfig.Common.enableProtocolCheck) {
                    return cv.equals(this.channelVersion);
                }
                return true;
            }).eventNetworkChannel();
            channel.registerObject((Object)this);
        }

        @SubscribeEvent
        public void onServerEvent(NetworkEvent.ClientCustomPayloadEvent event) {
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            IServerPacketHandler packetHandler = arg_0 -> ((NetworkEvent.Context)context).enqueueWork(arg_0);
            AbstractFriendlyByteBuf payload = AbstractFriendlyByteBuf.wrap((ByteBuf)event.getPayload());
            this.didReceivePacket(packetHandler, (IFriendlyByteBuf)payload, player);
            context.setPacketHandled(true);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onClientEvent(NetworkEvent.ServerCustomPayloadEvent event) {
            if (event instanceof NetworkEvent.ServerCustomPayloadLoginEvent) {
                return;
            }
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            IClientPacketHandler packetHandler = arg_0 -> ((NetworkEvent.Context)context).enqueueWork(arg_0);
            AbstractFriendlyByteBuf payload = AbstractFriendlyByteBuf.wrap((ByteBuf)event.getPayload());
            this.didReceivePacket(packetHandler, (IFriendlyByteBuf)payload, null);
            context.setPacketHandled(true);
        }
    }
}

