/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.compatibility.forge;

import com.mojang.authlib.GameProfile;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.permission.IPermissionContext;
import moe.plushie.armourers_workshop.api.permission.IPermissionNode;
import moe.plushie.armourers_workshop.core.permission.BlockPermissionContext;
import moe.plushie.armourers_workshop.core.permission.PlayerPermissionContext;
import moe.plushie.armourers_workshop.core.permission.TargetPermissionContext;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.init.platform.forge.builder.PermissionNodeBuilderImpl;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;
import net.minecraftforge.server.permission.context.BlockPosContext;
import net.minecraftforge.server.permission.context.IContext;
import net.minecraftforge.server.permission.context.PlayerContext;
import net.minecraftforge.server.permission.context.TargetContext;

public abstract class AbstractForgePermissionManager {
    public static IPermissionNode makeNode(IResourceLocation registryName, int level) {
        PermissionNodeBuilderImpl.NodeImpl nodeImpl = new PermissionNodeBuilderImpl.NodeImpl(registryName){

            @Override
            public boolean resolve(GameProfile profile, IPermissionContext context) {
                return PermissionAPI.hasPermission((GameProfile)profile, (String)this.key(), (IContext)AbstractForgePermissionManager.of(context));
            }
        };
        PermissionAPI.registerNode((String)nodeImpl.key(), (DefaultPermissionLevel)AbstractForgePermissionManager.of(level), (String)nodeImpl.name().func_150261_e());
        return nodeImpl;
    }

    private static DefaultPermissionLevel of(int level) {
        DefaultPermissionLevel defaultPermissionLevel;
        switch (level) {
            case 0: {
                defaultPermissionLevel = DefaultPermissionLevel.ALL;
                break;
            }
            case 3: {
                defaultPermissionLevel = DefaultPermissionLevel.OP;
                break;
            }
            default: {
                defaultPermissionLevel = DefaultPermissionLevel.NONE;
            }
        }
        return defaultPermissionLevel;
    }

    private static IContext of(IPermissionContext context) {
        if (context == null) {
            return null;
        }
        BlockPermissionContext block = Objects.safeCast(context, BlockPermissionContext.class);
        if (block != null) {
            return new BlockPosContext(block.player, block.blockPos, block.blockState, block.facing);
        }
        TargetPermissionContext target = Objects.safeCast(context, TargetPermissionContext.class);
        if (target != null) {
            return new TargetContext(target.player, target.target);
        }
        PlayerPermissionContext player = Objects.safeCast(context, PlayerPermissionContext.class);
        if (player != null) {
            return new PlayerContext(player.player);
        }
        return null;
    }
}

