/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.armature;

import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.EntityType;

public class ArmatureTransformerContext {
    private final EntityType<?> entityType;
    private IModel entityModel;
    private EntityRenderer<?> entityRenderer;
    private final ArrayList<Consumer<IModel>> entityModelListeners = new ArrayList();
    private final ArrayList<Consumer<EntityRenderer<?>>> entityRendererListeners = new ArrayList();

    public ArmatureTransformerContext(EntityType<?> entityType, IModel entityModel) {
        this.entityType = entityType;
        this.entityModel = entityModel;
    }

    public EntityType<?> entityType() {
        return this.entityType;
    }

    public void setEntityModel(IModel entityModel) {
        this.entityModel = entityModel;
        this.entityModelListeners.forEach((Consumer<Consumer<IModel>>)((Consumer<Consumer>)it -> it.accept(entityModel)));
    }

    public void setEntityModel0(IModel entityModel) {
        this.entityModel = entityModel;
    }

    public IModel entityModel() {
        return this.entityModel;
    }

    public void setEntityRenderer(EntityRenderer<?> entityRenderer) {
        this.entityRenderer = entityRenderer;
        this.entityRendererListeners.forEach((Consumer<Consumer<EntityRenderer<?>>>)((Consumer<Consumer>)it -> it.accept(entityRenderer)));
    }

    public void setEntityRenderer0(EntityRenderer<?> entityRenderer) {
        this.entityRenderer = entityRenderer;
    }

    public EntityRenderer<?> entityRenderer() {
        return this.entityRenderer;
    }

    public void addEntityModelListener(Consumer<IModel> callback) {
        this.entityModelListeners.add(callback);
        if (this.entityModel != null) {
            callback.accept(this.entityModel);
        }
    }

    public void addEntityRendererListener(Consumer<EntityRenderer<?>> callback) {
        this.entityRendererListeners.add(callback);
        if (this.entityRenderer != null) {
            callback.accept(this.entityRenderer);
        }
    }
}

