/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.bake;

import com.google.common.collect.Range;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moe.plushie.armourers_workshop.api.skin.part.features.ICanUse;
import moe.plushie.armourers_workshop.core.client.animation.AnimatedTransform;
import moe.plushie.armourers_workshop.core.client.animation.AnimationController;
import moe.plushie.armourers_workshop.core.client.bake.BakedAdapterJointTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedAttachmentPartTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedBackpackPartTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedItemTransform;
import moe.plushie.armourers_workshop.core.client.bake.BakedRenderInfo;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinAnimationHandler;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPartCombiner;
import moe.plushie.armourers_workshop.core.client.model.SkinItemTransform;
import moe.plushie.armourers_workshop.core.client.other.PlaceholderManager;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderContext;
import moe.plushie.armourers_workshop.core.client.skinrender.SkinRenderer;
import moe.plushie.armourers_workshop.core.client.texture.EntityTextureLoader;
import moe.plushie.armourers_workshop.core.data.cache.PrimaryKey;
import moe.plushie.armourers_workshop.core.data.color.ColorDescriptor;
import moe.plushie.armourers_workshop.core.entity.MannequinEntity;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import moe.plushie.armourers_workshop.core.math.OpenQuaternionf;
import moe.plushie.armourers_workshop.core.math.OpenRectangle3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVector3i;
import moe.plushie.armourers_workshop.core.math.OpenVector4f;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.Skin;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.core.skin.SkinTypes;
import moe.plushie.armourers_workshop.core.skin.animation.SkinAnimation;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartType;
import moe.plushie.armourers_workshop.core.skin.part.SkinPartTypes;
import moe.plushie.armourers_workshop.core.skin.part.wings.WingPartTransform;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperties;
import moe.plushie.armourers_workshop.core.skin.property.SkinProperty;
import moe.plushie.armourers_workshop.core.skin.serializer.SkinUsedCounter;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.Objects;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.OpenItemTransforms;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BakedSkin {
    private final int id = OpenRandomSource.nextInt(BakedSkin.class);
    private final String identifier;
    private final Skin skin;
    private final SkinType skinType;
    private final HashMap<Object, OpenRectangle3f> cachedBounds = new HashMap();
    private final HashMap<OpenVector3i, OpenRectangle3f> cachedBlockBounds = new HashMap();
    private final Range<Integer> useTickRange;
    private final List<BakedSkinPart> skinParts;
    private final List<AnimationController> animationControllers;
    private final ColorDescriptor colorDescriptor;
    private final SkinUsedCounter usedCounter;
    private final BakedRenderInfo renderInfo;
    private final BakedItemTransform itemTransform;
    private final SkinPaintScheme paintScheme;
    private final Int2ObjectMap<SkinPaintScheme> resolvedColorSchemes = new Int2ObjectOpenHashMap();
    private final BakedSkinAnimationHandler animationHandler = new BakedSkinAnimationHandler();

    public BakedSkin(String identifier, SkinType skinType, ArrayList<BakedSkinPart> bakedParts, Skin skin, SkinPaintScheme paintScheme, ColorDescriptor colorDescriptor, BakedRenderInfo renderInfo, SkinUsedCounter usedCounter) {
        this.identifier = identifier;
        this.skin = skin;
        this.skinType = skinType;
        this.animationControllers = this.resolveAnimationControllers(bakedParts, skin.animations(), skin.properties());
        this.skinParts = BakedSkinPartCombiner.apply(bakedParts);
        this.paintScheme = paintScheme;
        this.colorDescriptor = colorDescriptor;
        this.usedCounter = usedCounter;
        this.renderInfo = renderInfo;
        this.useTickRange = this.getUseTickRange(this.skinParts);
        this.itemTransform = this.resolvedItemTransform(this.skinParts, skin);
        this.loadBlockBounds(this.skinParts);
        this.loadPartTransforms(this.skinParts);
    }

    public void setupAnim(Entity entity, BakedArmature bakedArmature, SkinRenderContext context) {
        this.animationHandler.apply(this, entity, bakedArmature, context);
    }

    public SkinPaintScheme resolve(Entity entity, SkinPaintScheme scheme) {
        if (this.colorDescriptor.isEmpty()) {
            return SkinPaintScheme.EMPTY;
        }
        SkinPaintScheme resolvedColorScheme = (SkinPaintScheme)this.resolvedColorSchemes.computeIfAbsent(entity.func_145782_y(), k -> this.paintScheme.copy());
        if (PlaceholderManager.isPlaceholder(entity)) {
            OpenResourceLocation resolvedTexture = EntityTextureLoader.getInstance().getTextureLocation(entity);
            if (!Objects.equals(resolvedColorScheme.texture(), resolvedTexture)) {
                resolvedColorScheme.setTexture(resolvedTexture);
            }
        }
        resolvedColorScheme.setReference(scheme);
        return resolvedColorScheme;
    }

    public int id() {
        return this.id;
    }

    public String identifier() {
        return this.identifier;
    }

    public Skin skin() {
        return this.skin;
    }

    public SkinType type() {
        return this.skinType;
    }

    public List<BakedSkinPart> parts() {
        return this.skinParts;
    }

    public SkinProperties properties() {
        return this.skin.properties();
    }

    public List<AnimationController> animationControllers() {
        return this.animationControllers;
    }

    public SkinPaintScheme paintScheme() {
        return this.paintScheme;
    }

    public ColorDescriptor colorDescriptor() {
        return this.colorDescriptor;
    }

    public BakedItemTransform itemTransform() {
        return this.itemTransform;
    }

    public Range<Integer> useTickRange() {
        return this.useTickRange;
    }

    public SkinUsedCounter usedCounter() {
        return this.usedCounter;
    }

    public BakedRenderInfo renderInfo() {
        return this.renderInfo;
    }

    public Map<OpenVector3i, OpenRectangle3f> blockBounds() {
        return this.cachedBlockBounds;
    }

    public OpenRectangle3f renderBounds() {
        return this.getRenderBounds(SkinItemTransform.NO_TRANSFORM, OpenItemDisplayContext.NONE);
    }

    public OpenRectangle3f getRenderBounds(SkinItemTransform itemTransform, OpenItemDisplayContext displayContext) {
        OpenVector3f rotation = itemTransform.rotation();
        PrimaryKey key = PrimaryKey.of(rotation, (Object)displayContext);
        OpenRectangle3f bounds = this.cachedBounds.get(key);
        if (bounds != null) {
            return bounds;
        }
        MannequinEntity entity = PlaceholderManager.MANNEQUIN.get();
        OpenMatrix4f matrix = OpenMatrix4f.createScaleMatrix(1.0f, 1.0f, 1.0f);
        OpenVoxelShape shape = this.getRenderShape((Entity)entity, BakedArmature.defaultBy(this.skinType), displayContext);
        if (!rotation.equals(OpenVector3f.ZERO)) {
            matrix.rotate(new OpenQuaternionf(rotation.x(), rotation.y(), rotation.z(), true));
            shape.mul(matrix);
        }
        bounds = shape.bounds().copy();
        if (!rotation.equals(OpenVector3f.ZERO)) {
            OpenVector4f center = new OpenVector4f(bounds.center());
            matrix.invert();
            center.transform(matrix);
            bounds.setX(center.x() - bounds.width() / 2.0f);
            bounds.setY(center.y() - bounds.height() / 2.0f);
            bounds.setZ(center.z() - bounds.depth() / 2.0f);
        }
        this.cachedBounds.put(key.copy(), bounds);
        return bounds;
    }

    private OpenVoxelShape getRenderShape(Entity entity, BakedArmature armature, OpenItemDisplayContext displayContext) {
        if (armature == null) {
            return OpenVoxelShape.empty();
        }
        SkinRenderContext context = new SkinRenderContext();
        context.setItemSource(SkinItemSource.EMPTY);
        context.setDisplayContext(displayContext);
        context.setAnimationTicks(0.0);
        this.setupAnim(entity, armature, context);
        return SkinRenderer.getShape(entity, armature, this, context.pose());
    }

    private void loadPartTransforms(List<BakedSkinPart> skinParts) {
        Collections.eachTree(skinParts, BakedSkinPart::children, part -> {
            if (part.properties().get(SkinProperty.USE_ADAPT_MODE).booleanValue()) {
                BakedAdapterJointTransform adapterTransform = new BakedAdapterJointTransform((BakedSkinPart)part);
                part.setJointTransformModifier(it -> adapterTransform);
                this.animationHandler.normal((skin, entity, armature, context) -> adapterTransform.setup(entity, armature, context));
            }
        });
        Collections.eachTree(skinParts, BakedSkinPart::children, part -> part.transform().children().forEach(transform -> {
            if (transform instanceof AnimatedTransform) {
                AnimatedTransform animatedTransform = (AnimatedTransform)transform;
                this.animationHandler.lowest((skin, entity, armature, context) -> animatedTransform.reset());
            }
        }));
        skinParts.forEach(it -> it.transform().children().forEach(transform -> {
            if (transform instanceof WingPartTransform) {
                WingPartTransform wingTransform = (WingPartTransform)transform;
                this.animationHandler.normal((skin, entity, armature, context) -> wingTransform.setup(entity, context.animationTicks()));
            }
        }));
        BakedAttachmentPartTransform.create(skinParts).forEach(attachmentTransform -> this.animationHandler.normal((skin, entity, armature, context) -> attachmentTransform.setup(entity, armature, context)));
        Collections.filter(skinParts, it -> it.type() == SkinPartTypes.ITEM_BACKPACK).forEach(it -> {
            BakedBackpackPartTransform backpackTransform = new BakedBackpackPartTransform();
            it.transform().insertChild(backpackTransform, 0);
            this.animationHandler.highest((skin, entity, armature, context) -> backpackTransform.setup(entity, context.renderData()));
        });
    }

    private void loadBlockBounds(List<BakedSkinPart> skinParts) {
        if (this.skinType != SkinTypes.BLOCK) {
            return;
        }
        for (BakedSkinPart skinPart : skinParts) {
            Map<OpenVector3i, OpenRectangle3f> bounds = skinPart.part().blockBounds();
            if (bounds == null) continue;
            this.cachedBlockBounds.putAll(bounds);
        }
    }

    private Range<Integer> getUseTickRange(List<BakedSkinPart> skinParts) {
        int count = 0;
        int maxUseTick = Integer.MIN_VALUE;
        int minUseTick = Integer.MAX_VALUE;
        for (BakedSkinPart bakedPart : skinParts) {
            SkinPartType skinPartType = bakedPart.type();
            if (!(skinPartType instanceof ICanUse)) continue;
            ICanUse partType = (ICanUse)((Object)skinPartType);
            Range<Integer> range = partType.useRange();
            maxUseTick = Math.max(maxUseTick, (Integer)range.upperEndpoint());
            minUseTick = Math.min(minUseTick, (Integer)range.lowerEndpoint());
            ++count;
        }
        if (count == 0) {
            return Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
        }
        return Range.closed((Comparable)Integer.valueOf(minUseTick), (Comparable)Integer.valueOf(maxUseTick));
    }

    private BakedItemTransform resolvedItemTransform(List<BakedSkinPart> skinParts, Skin skin) {
        OpenItemTransforms itemTransforms = skin.itemTransforms();
        return BakedItemTransform.create(skinParts, itemTransforms, skin.type());
    }

    private List<AnimationController> resolveAnimationControllers(List<BakedSkinPart> skinParts, Collection<SkinAnimation> animations, SkinProperties properties) {
        ArrayList<AnimationController> animationControllers = new ArrayList<AnimationController>();
        if (animations.isEmpty()) {
            return animationControllers;
        }
        HashMap namedParts = new HashMap();
        Collections.eachTree(skinParts, BakedSkinPart::children, part -> {
            String partName = part.name();
            if (partName.isEmpty()) {
                partName = part.type().name();
            }
            namedParts.put(partName, part.transform());
        });
        animations.forEach(animation -> {
            AnimationController controller = new AnimationController((SkinAnimation)animation, namedParts);
            animationControllers.add(controller);
        });
        animationControllers.removeIf(AnimationController::isEmpty);
        return animationControllers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BakedSkin)) {
            return false;
        }
        BakedSkin that = (BakedSkin)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public String toString() {
        return Objects.toString(this, "id", this.id, "skin", this.identifier, "type", this.skinType.registryName().toString());
    }
}

