/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.foundation.NSString;
import com.apple.library.uikit.UIColor;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.client.gui.screens.Screen.ABI;
import moe.plushie.armourers_workshop.core.client.gui.widget.ClientMenuScreen;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.client.gui.widget.NotificationDialog;
import moe.plushie.armourers_workshop.core.menu.AbstractContainerMenu;
import moe.plushie.armourers_workshop.core.network.ExecuteAlertPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ServerAlertWindow
extends MenuWindow<AbstractContainerMenu> {
    private final ExecuteAlertPacket alertPacket;

    public ServerAlertWindow(ExecuteAlertPacket alertPacket) {
        super(ClientMenuScreen.createEmptyMenu(), ClientMenuScreen.createEmptyInventory(), new NSString(alertPacket.title()));
        this.titleView.removeFromSuperview();
        this.inventoryView.removeFromSuperview();
        this.alertPacket = alertPacket;
    }

    @Override
    public void init() {
        NotificationDialog dialog = new NotificationDialog();
        dialog.setTitle(new NSString(this.alertPacket.title()));
        dialog.setMessage(new NSString(this.alertPacket.message()));
        if (this.alertPacket.type() == 1) {
            dialog.setMessageColor(UIColor.of(-43691));
        }
        dialog.setConfirmText(new NSString(this.alertPacket.confirm()));
        dialog.sizeToFit();
        dialog.showInView(this, this::dismiss);
    }

    public void showInScreen() {
        Minecraft minecraft = Minecraft.func_71410_x();
        WrappedScreen screen = new WrappedScreen(this, this.alertPacket.title());
        screen.setTarget(minecraft.field_71462_r);
        minecraft.field_71462_r = null;
        minecraft.func_147108_a((Screen)screen);
    }

    public void dismiss() {
        Minecraft minecraft = Minecraft.func_71410_x();
        Screen screen = minecraft.field_71462_r;
        if (screen instanceof WrappedScreen) {
            WrappedScreen screen2 = (WrappedScreen)screen;
            minecraft.func_147108_a(screen2.target());
        }
    }

    public static class WrappedScreen
    extends ClientMenuScreen {
        private Screen targetScreen;

        public WrappedScreen(ServerAlertWindow window, ITextComponent component) {
            super(window, component);
        }

        @Override
        public void func_231152_a_(Minecraft minecraft, int i, int j) {
            super.func_231152_a_(minecraft, i, j);
            if (this.targetScreen != null) {
                this.targetScreen.func_231152_a_(minecraft, i, j);
            }
        }

        @Override
        public void render(CGGraphicsContext context, int mouseX, int mouseY, float partialTicks) {
            if (this.targetScreen != null) {
                ABI.render(this.targetScreen, context, Integer.MIN_VALUE, Integer.MIN_VALUE, partialTicks);
            }
            context.saveGraphicsState();
            context.translateCTM(0.0f, 0.0f, 500.0f);
            super.render(context, mouseX, mouseY, partialTicks);
            context.restoreGraphicsState();
        }

        public void setTarget(Screen screen) {
            this.targetScreen = screen;
        }

        public Screen target() {
            return this.targetScreen;
        }
    }
}

