/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.gui.widget;

import com.apple.library.coregraphics.CGGraphicsContext;
import com.apple.library.coregraphics.CGPoint;
import com.apple.library.coregraphics.CGRect;
import com.apple.library.coregraphics.CGSize;
import com.apple.library.uikit.UIView;
import com.apple.library.uikit.UIWindow;
import com.apple.library.uikit.UIWindowManager;
import moe.plushie.armourers_workshop.compatibility.client.gui.AbstractMenuScreen;
import moe.plushie.armourers_workshop.core.client.gui.widget.MenuWindow;
import moe.plushie.armourers_workshop.core.utils.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ContainerMenuScreen<M extends Container, W extends UIWindow>
extends AbstractMenuScreen<M> {
    private final W window;
    private final MenuWindow<?> menuWindow;
    private final UIWindowManager manager;

    public ContainerMenuScreen(W window, M menu, PlayerInventory inventory, ITextComponent title) {
        super(menu, inventory, title);
        this.window = window;
        this.menuWindow = Objects.safeCast(window, MenuWindow.class);
        this.manager = new UIWindowManager();
        this.manager.addWindow((UIWindow)window);
        this.manager.init();
    }

    public void func_231160_c_() {
        CGSize screenSize = this.screenSize();
        this.manager.layout(screenSize.width, screenSize.height);
        CGRect rect = ((UIView)this.window).bounds();
        this.setContentSize(new CGSize(rect.width, rect.height));
        super.func_231160_c_();
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        super.func_231152_a_(minecraft, width, height);
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.menuWindow.screenWillTick();
    }

    public void func_231164_f_() {
        super.func_231164_f_();
        this.manager.deinit();
    }

    @Override
    public void render(CGGraphicsContext context, int mouseX, int mouseY, float partialTicks) {
        this.manager.tick();
        this.manager.render(context, this::_render, this::_renderBackground, this::_renderTooltip);
    }

    @Override
    public void renderLabels(CGGraphicsContext context, int mouseX, int mouseY) {
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return this.manager.mouseDown(mouseX, mouseY, button, this::_mouseClicked);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        return this.manager.mouseUp(mouseX, mouseY, button, this::_mouseReleased);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        return this.manager.mouseWheel(mouseX, mouseY, new CGPoint(deltaX, deltaY), this::_mouseScrolled);
    }

    public void func_212927_b(double mouseX, double mouseY) {
        this.manager.mouseMoved(mouseX, mouseY, 0, this::_mouseMoved);
    }

    public boolean func_231046_a_(int key, int i, int j) {
        return this.manager.keyDown(key, i, j, this::_keyPressed);
    }

    public boolean func_223281_a_(int key, int i, int j) {
        return this.manager.keyUp(key, i, j, this::_keyReleased);
    }

    public boolean func_231042_a_(char ch, int i) {
        return this.manager.charTyped(ch, i, 0, this::_charTyped);
    }

    public boolean func_195361_a(double mouseX, double mouseY, int left, int top, int button) {
        return !this.manager.mouseIsInside(mouseX, mouseY, button);
    }

    public void func_184098_a(Slot slot, int slotIndex, int j, ClickType clickType) {
        super.func_184098_a(slot, slotIndex, j, clickType);
        this.menuWindow.menuDidChange();
    }

    public boolean func_231049_c__(boolean bl) {
        return this.manager.changeKeyView(bl);
    }

    public boolean shouldRenderExtendScreen() {
        if (this.menuWindow != null) {
            return this.menuWindow.shouldRenderExtendScreen();
        }
        return false;
    }

    protected void _render(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        super.render(context, mouseX, mouseY, partialTicks);
    }

    protected void _renderTooltip(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        context.saveGraphicsState();
        context.translateCTM(0.0f, 0.0f, 400.0f);
        this.renderTooltip(context, mouseX, mouseY);
        context.restoreGraphicsState();
    }

    protected void _renderBackground(int mouseX, int mouseY, float partialTicks, CGGraphicsContext context) {
        if (this.menuWindow != null && this.menuWindow.shouldRenderBackground()) {
            this.renderBackground(context);
        }
    }

    protected boolean _charTyped(int key, int i, int j) {
        super.func_231042_a_((char)key, i);
        return true;
    }

    protected boolean _keyPressed(int key, int i, int j) {
        if (this.manager.isTextEditing() && !this._editingPassKey((char)key)) {
            return false;
        }
        return super.func_231046_a_(key, i, j);
    }

    protected boolean _keyReleased(int key, int i, int j) {
        return super.func_223281_a_(key, i, j);
    }

    protected boolean _mouseClicked(double mouseX, double mouseY, int button) {
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    protected boolean _mouseMoved(double mouseX, double mouseY, int button) {
        super.func_212927_b(mouseX, mouseY);
        return true;
    }

    protected boolean _mouseScrolled(double mouseX, double mouseY, CGPoint delta) {
        return super.mouseScrolled(mouseX, mouseY, delta.x(), delta.y());
    }

    protected boolean _mouseReleased(double mouseX, double mouseY, int button) {
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    protected boolean _editingPassKey(int key) {
        boolean bl;
        switch (key) {
            case 256: {
                bl = true;
                break;
            }
            case 258: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

