/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.Iterator;
import java.util.function.Function;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.compatibility.client.AbstractPoseStack;
import moe.plushie.armourers_workshop.core.client.animation.AnimationManager;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferBuilder;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentRenderingContext;
import moe.plushie.armourers_workshop.core.client.other.EntityRenderData;
import moe.plushie.armourers_workshop.core.client.other.SkinItemSource;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferSource;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.core.utils.OpenItemDisplayContext;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkinRenderContext
implements ConcurrentRenderingContext {
    public static final SkinRenderContext EMPTY = new SkinRenderContext();
    private static final Iterator<SkinRenderContext> POOL = Collections.cycle(Collections.newList(100, i -> new SkinRenderContext()));
    protected int lightmap = 0xF000F0;
    protected int overlay = OverlayTexture.field_229196_a_;
    protected int outlineColor = 0;
    protected float partialTicks = 0.0f;
    protected double animationTicks = 0.0;
    protected IBufferSource bufferSource;
    protected EntityRenderData renderData;
    protected Function<BakedSkin, ConcurrentBufferBuilder> bufferProvider;
    protected SkinItemSource itemSource;
    protected boolean useItemTransforms = false;
    protected OpenVector3f displayBox;
    protected SkinPaintScheme colorScheme = SkinPaintScheme.EMPTY;
    protected AnimationManager animationManager;
    protected OpenItemDisplayContext displayContext = OpenItemDisplayContext.NONE;
    protected final IPoseStack defaultPoseStack;
    protected IPoseStack poseStack;
    protected IPoseStack modelViewStack;

    public SkinRenderContext() {
        this(new AbstractPoseStack());
    }

    public SkinRenderContext(IPoseStack poseStack) {
        this.poseStack = this.defaultPoseStack = poseStack;
    }

    public static SkinRenderContext alloc(EntityRenderData renderData, int light, float partialTick, OpenItemDisplayContext itemDisplayContext) {
        SkinRenderContext context = POOL.next();
        context.setRenderData(renderData);
        context.setLightmap(light);
        context.setPartialTicks(partialTick);
        context.setAnimationTicks(TickUtils.animationTicks());
        context.setDisplayBox(null);
        context.setDisplayContext(itemDisplayContext);
        context.setUseItemTransforms(false);
        return context;
    }

    public static SkinRenderContext alloc(EntityRenderData renderData, int light, float partialTick) {
        return SkinRenderContext.alloc(renderData, light, partialTick, OpenItemDisplayContext.NONE);
    }

    public void release() {
        this.overlay = OverlayTexture.field_229196_a_;
        this.lightmap = 0xF000F0;
        this.outlineColor = 0;
        this.partialTicks = 0.0f;
        this.colorScheme = SkinPaintScheme.EMPTY;
        this.displayContext = OpenItemDisplayContext.NONE;
        this.itemSource = SkinItemSource.EMPTY;
        this.displayBox = null;
        this.useItemTransforms = false;
        this.poseStack = this.defaultPoseStack;
        this.bufferProvider = null;
        this.renderData = null;
        this.bufferSource = null;
        this.animationManager = null;
    }

    public void pushPose() {
        this.poseStack.pushPose();
    }

    public void popPose() {
        this.poseStack.popPose();
    }

    public IPoseStack pose() {
        return this.poseStack;
    }

    public void setLightmap(int lightmap) {
        this.lightmap = lightmap;
    }

    @Override
    public int lightmap() {
        return this.lightmap;
    }

    public void setOverlay(int overlay) {
        this.overlay = overlay;
    }

    @Override
    public int overlay() {
        return this.overlay;
    }

    public void setPartialTicks(float partialTicks) {
        this.partialTicks = partialTicks;
    }

    @Override
    public float partialTicks() {
        return this.partialTicks;
    }

    public void setAnimationTicks(double animationTicks) {
        this.animationTicks = animationTicks;
    }

    @Override
    public double animationTicks() {
        return this.animationTicks;
    }

    public void setColorScheme(SkinPaintScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public SkinPaintScheme colorScheme() {
        return this.colorScheme;
    }

    public void setDisplayContext(OpenItemDisplayContext displayContext) {
        this.displayContext = displayContext;
    }

    public OpenItemDisplayContext displayContext() {
        return this.displayContext;
    }

    public void setDisplayBox(OpenVector3f displayBox) {
        this.displayBox = displayBox;
    }

    public OpenVector3f displayBox() {
        return this.displayBox;
    }

    public void setRenderData(EntityRenderData renderData) {
        this.renderData = renderData;
    }

    public EntityRenderData renderData() {
        return this.renderData;
    }

    public void setAnimationManager(AnimationManager animationManager) {
        this.animationManager = animationManager;
    }

    public AnimationManager animationManager() {
        if (this.renderData != null) {
            return this.renderData.animationManager();
        }
        if (this.animationManager != null) {
            return this.animationManager;
        }
        return AnimationManager.NONE;
    }

    @Override
    public ConcurrentBufferBuilder getBuffer(@NotNull BakedSkin skin) {
        if (this.bufferProvider != null) {
            return this.bufferProvider.apply(skin);
        }
        boolean isOutline = this.shouldRenderOutline();
        SkinVertexBufferSource skinBufferSource = SkinVertexBufferSource.of(this.bufferSource, isOutline, skin.renderInfo());
        return skinBufferSource.getBuffer(skin);
    }

    public void setBufferProvider(Function<BakedSkin, ConcurrentBufferBuilder> bufferProvider) {
        this.bufferProvider = bufferProvider;
    }

    public void setOutlineColor(int outlineColor) {
        this.outlineColor = outlineColor;
    }

    @Override
    public int outlineColor() {
        return this.outlineColor;
    }

    @Override
    public boolean shouldRenderOutline() {
        return this.outlineColor != 0;
    }

    @Override
    public float renderPriority() {
        if (this.itemSource != null) {
            return this.itemSource.renderPriority();
        }
        return 0.0f;
    }

    public void setItemSource(SkinItemSource itemSource) {
        this.itemSource = itemSource;
    }

    @Override
    public SkinItemSource itemSource() {
        if (this.itemSource != null) {
            return this.itemSource;
        }
        return SkinItemSource.EMPTY;
    }

    public void setUseItemTransforms(boolean useItemTransforms) {
        this.useItemTransforms = useItemTransforms;
    }

    public boolean isUseItemTransforms() {
        return this.useItemTransforms;
    }

    public void setPoseStack(IPoseStack pose) {
        this.poseStack = pose;
    }

    @Override
    public IPoseStack poseStack() {
        return this.poseStack;
    }

    public void setBufferSource(IBufferSource bufferSource) {
        this.bufferSource = bufferSource;
    }

    @Override
    public IBufferSource bufferSource() {
        return this.bufferSource;
    }

    public void setModelViewStack(IPoseStack modelViewStack) {
        this.modelViewStack = modelViewStack;
    }

    @Override
    public IPoseStack modelViewStack() {
        return this.modelViewStack;
    }
}

