/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.api.core.math.IPoseStack;
import moe.plushie.armourers_workshop.api.core.math.IRectangle3f;
import moe.plushie.armourers_workshop.core.armature.Armature;
import moe.plushie.armourers_workshop.core.armature.JointShape;
import moe.plushie.armourers_workshop.core.client.bake.BakedArmature;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkinPart;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferBuilder;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferCompiler;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentRenderingContext;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentRenderingPipeline;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferSource;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;
import moe.plushie.armourers_workshop.core.math.OpenVoxelShape;
import moe.plushie.armourers_workshop.core.skin.texture.SkinPaintScheme;
import moe.plushie.armourers_workshop.core.utils.ColorUtils;
import moe.plushie.armourers_workshop.init.ModDebugger;
import moe.plushie.armourers_workshop.utils.ShapeTesselator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SkinVertexBufferBuilder
implements ConcurrentBufferBuilder {
    protected final BakedSkin skin;
    protected final ConcurrentBufferCompiler compiler = new ConcurrentBufferCompiler();
    protected final ConcurrentRenderingPipeline pipeline = new ConcurrentRenderingPipeline();

    public SkinVertexBufferBuilder(BakedSkin skin) {
        this.skin = skin;
    }

    @Override
    public void addPart(BakedSkinPart part, BakedSkin skin, SkinPaintScheme scheme, ConcurrentRenderingContext context) {
        if (ModDebugger.vbo) {
            this.drawWithoutVBO(part, skin, scheme, context);
            return;
        }
        this.draw(part, skin, scheme, false, context);
        if (context.shouldRenderOutline()) {
            this.draw(part, skin, scheme, true, context);
        }
    }

    @Override
    public void addShape(OpenVector3f origin, ConcurrentRenderingContext context) {
        ShapeTesselator.vector(origin, 16.0f, context.poseStack(), context.bufferSource());
    }

    @Override
    public void addShape(OpenVoxelShape shape, int color, ConcurrentRenderingContext context) {
        ShapeTesselator.stroke((IRectangle3f)shape.bounds(), color, context.poseStack(), context.bufferSource());
    }

    @Override
    public void addShape(BakedArmature armature, ConcurrentRenderingContext context) {
        IBufferSource bufferSource = context.bufferSource();
        IPoseStack poseStack = context.poseStack();
        IJointTransform[] transforms = armature.transforms();
        Armature armature1 = armature.armature();
        for (IJoint joint : armature1.allJoints()) {
            JointShape shape = armature1.shapeById(joint.id());
            IJointTransform transform = transforms[joint.id()];
            if (ModDebugger.defaultArmature) {
                transform = armature1.globalTransformById(joint.id());
            }
            if (shape == null || transform == null) continue;
            poseStack.pushPose();
            transform.apply(poseStack);
            ShapeTesselator.stroke(shape, ColorUtils.getPaletteColor(joint.id()), poseStack, bufferSource);
            ShapeTesselator.vector(0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, poseStack, bufferSource);
            poseStack.popPose();
        }
    }

    public void endBatch(Consumer<ShaderVertexObject> consumer) {
        this.pipeline.commit(consumer);
    }

    private void draw(BakedSkinPart part, BakedSkin skin, SkinPaintScheme scheme, boolean isOutline, ConcurrentRenderingContext context) {
        ConcurrentBufferCompiler.Group group = this.compiler.compile(part, skin, scheme, isOutline);
        if (group != null && !group.isEmpty() && part.isVisible()) {
            this.pipeline.add(group, context);
        }
    }

    private void drawWithoutVBO(BakedSkinPart part, BakedSkin skin, SkinPaintScheme scheme, ConcurrentRenderingContext context) {
        IPoseStack poseStack = context.poseStack();
        IBufferSource bufferSource = context.bufferSource();
        part.quads().forEach((renderType, quads) -> {
            IVertexConsumer builder = bufferSource.getBuffer((IRenderType)renderType);
            quads.forEach((transform, faces) -> {
                poseStack.pushPose();
                transform.apply(poseStack);
                faces.forEach(face -> face.render(part, scheme, context.lightmap(), context.overlay(), poseStack, builder));
                poseStack.popPose();
            });
        });
    }

    private void drawWithVBO(ConcurrentBufferCompiler.Group group, ConcurrentRenderingContext context) {
        ConcurrentRenderingPipeline pipeline1 = new ConcurrentRenderingPipeline();
        SkinVertexBufferSource.Pipeline pipeline2 = new SkinVertexBufferSource.Pipeline();
        pipeline1.add(group, context);
        pipeline1.commit(pipeline2::add);
        pipeline2.end();
    }
}

