/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.other;

import java.util.HashMap;
import moe.plushie.armourers_workshop.api.client.IBufferBuilder;
import moe.plushie.armourers_workshop.api.client.IBufferSource;
import moe.plushie.armourers_workshop.api.client.IRenderAttachable;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.api.client.IVertexConsumer;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferBuilder;
import moe.plushie.armourers_workshop.compatibility.client.AbstractBufferSource;
import moe.plushie.armourers_workshop.compatibility.client.AbstractShader;
import moe.plushie.armourers_workshop.core.client.bake.BakedRenderInfo;
import moe.plushie.armourers_workshop.core.client.bake.BakedSkin;
import moe.plushie.armourers_workshop.core.client.other.ConcurrentBufferCompiler;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderSheets;
import moe.plushie.armourers_workshop.core.client.other.SkinVertexBufferBuilder;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexGroup;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexMerger;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SkinVertexBufferSource
implements IBufferSource {
    private static final SkinVertexBufferSource INSTANCE = new SkinVertexBufferSource();
    protected final HashMap<BakedSkin, SkinVertexBufferBuilder> skinBufferBuilders = new HashMap();
    protected final HashMap<BakedSkin, SkinVertexBufferBuilder> startedSkinBufferBuilders = new HashMap();
    protected final HashMap<IRenderType, AbstractBufferBuilder> bufferBuilders = new HashMap();
    protected final HashMap<IRenderType, AbstractBufferBuilder> startedBufferBuilders = new HashMap();
    protected final Pipeline solidPipeline = new Pipeline();
    protected final Pipeline outlinePipeline = new Pipeline();
    protected final Pipeline translucentPipeline = new Pipeline();

    public static SkinVertexBufferSource of(IBufferSource bufferSource) {
        SkinVertexBufferSource.attach(bufferSource, SkinRenderSheets.solidBlockSheet(), INSTANCE::flush);
        return INSTANCE;
    }

    public static SkinVertexBufferSource of(IBufferSource bufferSource, boolean shouldRenderOutline, BakedRenderInfo renderInfo) {
        SkinVertexBufferSource.attach(bufferSource, SkinRenderSheets.solidBlockSheet(), INSTANCE::endBatch);
        if (renderInfo.hasTranslucent()) {
            SkinVertexBufferSource.attach(bufferSource, SkinRenderSheets.glintTranslucentSheet(), INSTANCE::endTranslucentBatch);
        }
        if (shouldRenderOutline) {
            SkinVertexBufferSource.attach(AbstractBufferSource.outline(), SkinRenderSheets.outlineSolidBlockSheet(), INSTANCE::endOutlineBatch);
        }
        return INSTANCE;
    }

    public static void clearAllCache() {
        INSTANCE.clean();
        ConcurrentBufferCompiler.clearAllCache();
    }

    private static void attach(IBufferSource bufferSource, IRenderType renderType, Runnable action) {
        IVertexConsumer buffer = bufferSource.getBuffer(renderType);
        Object t = renderType.get();
        if (t instanceof IRenderAttachable) {
            IRenderAttachable attachable = (IRenderAttachable)t;
            attachable.attachRenderTask(buffer, action);
        }
    }

    @Override
    @NotNull
    public IBufferBuilder getBuffer(@NotNull IRenderType renderType) {
        AbstractBufferBuilder buffer = this.startedBufferBuilders.get(renderType);
        if (buffer != null) {
            return buffer;
        }
        buffer = this.bufferBuilders.computeIfAbsent(renderType, k -> new AbstractBufferBuilder(k.bufferSize()));
        buffer.begin(renderType);
        this.startedBufferBuilders.put(renderType, buffer);
        return buffer;
    }

    public SkinVertexBufferBuilder getBuffer(@NotNull BakedSkin skin) {
        SkinVertexBufferBuilder bufferBuilder = this.startedSkinBufferBuilders.get(skin);
        if (bufferBuilder != null) {
            return bufferBuilder;
        }
        bufferBuilder = this.skinBufferBuilders.computeIfAbsent(skin, SkinVertexBufferBuilder::new);
        this.startedSkinBufferBuilders.put(skin, bufferBuilder);
        return bufferBuilder;
    }

    public void clean() {
        this.skinBufferBuilders.clear();
        this.bufferBuilders.clear();
        this.startedSkinBufferBuilders.clear();
        this.startedBufferBuilders.clear();
        this.solidPipeline.clear();
        this.outlinePipeline.clear();
        this.translucentPipeline.clear();
    }

    public void upload(ShaderVertexObject pass) {
        if (pass.isOutline()) {
            this.outlinePipeline.add(pass);
        } else if (pass.isTranslucent()) {
            this.translucentPipeline.add(pass);
        } else {
            this.solidPipeline.add(pass);
        }
    }

    public void flush() {
        this.endBatch();
        this.endTranslucentBatch();
    }

    @Override
    public void endBatch() {
        if (!this.startedSkinBufferBuilders.isEmpty()) {
            for (SkinVertexBufferBuilder builder : this.startedSkinBufferBuilders.values()) {
                builder.endBatch(this::upload);
            }
            this.startedSkinBufferBuilders.clear();
        }
        this.solidPipeline.end();
        if (!this.startedBufferBuilders.isEmpty()) {
            this.startedBufferBuilders.forEach(AbstractBufferBuilder::upload);
            this.startedBufferBuilders.clear();
        }
    }

    public void endOutlineBatch() {
        this.outlinePipeline.end();
    }

    public void endTranslucentBatch() {
        this.translucentPipeline.end();
    }

    public static class Pipeline {
        private final AbstractShader shader = new AbstractShader();
        private final ShaderVertexMerger merger = new ShaderVertexMerger();

        public void add(ShaderVertexObject pass) {
            this.merger.add(pass);
        }

        public void end() {
            if (this.merger.isEmpty()) {
                return;
            }
            this.merger.prepare();
            this.shader.begin();
            this.merger.forEach(group -> this.shader.apply((ShaderVertexGroup)group, () -> group.forEach(this.shader::render)));
            this.shader.end();
            this.merger.reset();
        }

        public void clear() {
            this.merger.reset();
            this.merger.clear();
        }
    }
}

