/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import moe.plushie.armourers_workshop.core.utils.Collections;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderPreprocessor {
    public static final List<String> PATCHED_VANILLA_SHADERS = Collections.immutableList(builder -> {
        builder.add((Object)"rendertype_entity_solid");
        builder.add((Object)"rendertype_entity_shadow");
        builder.add((Object)"rendertype_entity_cutout");
        builder.add((Object)"rendertype_energy_swirl");
        builder.add((Object)"rendertype_outline");
    });
    private final String prefix;

    public ShaderPreprocessor(String prefix) {
        this.prefix = prefix;
    }

    public String process(String source) {
        String string;
        switch (this.prefix) {
            case "va": {
                string = this.processOptifineShader(new Builder(source));
                break;
            }
            case "iris_": {
                string = this.processIrisShader(new Builder(source));
                break;
            }
            case "frx_": {
                string = this.processCanvasShader(new Builder(source));
                break;
            }
            case "": {
                string = this.processVanillaShader(new Builder(source));
                break;
            }
            default: {
                string = source;
            }
        }
        return string;
    }

    private String processIrisShader(Builder builder) {
        builder.attribute("aw_UV0", "vec2", "iris_UV0", "mat4", "aw_TextureMatrix", "vec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_UV1", "ivec2", "iris_UV1", "mat4", "aw_OverlayTextureMatrix", "ivec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_UV2", "ivec2", "iris_UV2", "mat4", "aw_LightmapTextureMatrix", "ivec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_Color", "vec4", "iris_Color", "vec4", "aw_ColorModulator", "($2 * $1)");
        builder.attribute("aw_Normal", "vec3", "iris_Normal", "mat3", "aw_NormalMatrix", "($2 * $1)");
        builder.attribute("aw_Position", "vec3", "iris_Position", "mat4", "aw_ModelViewMat", "vec3($2 * vec4($1, 1))");
        return this.build("iris", builder);
    }

    private String processOptifineShader(Builder builder) {
        builder.attribute("aw_UV0", "vec2", "vaUV0", "mat4", "aw_TextureMatrix", "vec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_UV1", "ivec2", "vaUV1", "mat4", "aw_OverlayTextureMatrix", "ivec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_UV2", "ivec2", "vaUV2", "mat4", "aw_LightmapTextureMatrix", "ivec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_Color", "vec4", "vaColor", "vec4", "aw_ColorModulator", "($2 * $1)");
        builder.attribute("aw_Normal", "vec3", "vaNormal", "mat3", "aw_NormalMatrix", "($2 * $1)");
        builder.attribute("aw_Position", "vec3", "vaPosition", "mat4", "aw_ModelViewMat", "vec3($2 * vec4($1, 1))");
        return this.build("optifine", builder);
    }

    private String processCanvasShader(Builder builder) {
        return this.build("canvas", builder);
    }

    private String processVanillaShader(Builder builder) {
        builder.attribute("aw_UV0", "vec2", "UV0", "mat4", "aw_TextureMatrix", "vec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_UV1", "ivec2", "UV1", "mat4", "aw_OverlayTextureMatrix", "ivec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_UV2", "ivec2", "UV2", "mat4", "aw_LightmapTextureMatrix", "ivec2($2 * vec4($1, 1, 1))");
        builder.attribute("aw_Color", "vec4", "Color", "vec4", "aw_ColorModulator", "($2 * $1)");
        builder.attribute("aw_Normal", "vec3", "Normal", "mat3", "aw_NormalMatrix", "($2 * $1)");
        builder.attribute("aw_Position", "vec3", "Position", "mat4", "aw_ModelViewMat", "vec3($2 * vec4($1, 1))");
        return this.build("vanilla", builder);
    }

    private void processCommonShader(Builder builder) {
        if (builder.variables.contains("aw_Normal")) {
            builder.scripts.add("if ((aw_MatrixFlags & 0x02) != 0) {");
            builder.scripts.add("  aw_Normal = normalize(aw_Normal);");
            builder.scripts.add("}");
        }
    }

    private String build(String type, Builder builder) {
        this.processCommonShader(builder);
        String source = builder.build();
        if (ModConfig.Client.enableShaderDebug) {
            ModLog.info("process {} shader: \n{}", type, source);
        }
        return source;
    }

    public static class Builder {
        private String source;
        private final ArrayList<String> variables = new ArrayList();
        private final ArrayList<String> scripts = new ArrayList();
        private final ArrayList<String> initializer1 = new ArrayList();
        private final ArrayList<String> initializer2 = new ArrayList();

        public Builder(String source) {
            this.source = source;
        }

        public Builder uniform(String name, String varType, String var, String matrixType, String matrixVar, String expr) {
            this.source = this.register("uniform", name, this.source, varType, var, matrixType, matrixVar, expr);
            return this;
        }

        public Builder attribute(String name, String varType, String var, String matrixType, String matrixVar, String expr) {
            this.source = this.register("in", name, this.source, varType, var, matrixType, matrixVar, expr);
            return this;
        }

        private String register(String category, String name, String source, String varType, String var, String matrixType, String matrix, String expr) {
            int i;
            String[] texts = new String[]{"(${category}\\s+${varType}\\s+)(\\b${var}\\b)(.*?;)", "$1__aw_${var}_aw__$3", "\\b${var}\\b", "${name}", "(${category}\\s+${varType}\\s+)(\\b__aw_${var}_aw__)\\b(.*?;)", "uniform ${matrixType} ${matrix};\n${varType} ${name};\n$1${var}$3"};
            String[] regexes = new String[texts.length];
            for (i = 0; i < texts.length; ++i) {
                String tmp = texts[i];
                tmp = tmp.replace("${category}", category);
                tmp = tmp.replace("${name}", name);
                tmp = tmp.replace("${varType}", varType);
                tmp = tmp.replace("${var}", var);
                tmp = tmp.replace("${matrixType}", matrixType);
                regexes[i] = tmp = tmp.replace("${matrix}", matrix);
            }
            for (i = 0; i < regexes.length / 2; ++i) {
                String newValue = source.replaceAll(regexes[i * 2], regexes[i * 2 + 1]);
                if (i == 0 && newValue.equals(source)) {
                    return source;
                }
                source = newValue;
            }
            this.variables.add(name);
            this.variables.add(matrix);
            this.initializer1.add(name + " = " + var);
            this.initializer2.add(name + " = " + expr.replace("$1", var).replace("$2", matrix));
            return source;
        }

        public String build() {
            if (this.initializer1.isEmpty()) {
                return this.source;
            }
            SourceBuilder builder = new SourceBuilder();
            builder.append("#ifdef GL_ES\n");
            builder.append("uniform int aw_MatrixFlags;\n");
            builder.append("#else\n");
            builder.append("uniform int aw_MatrixFlags = 0;\n");
            builder.append("#endif\n");
            builder.append("void aw_main_pre() {\n");
            builder.append("  if ((aw_MatrixFlags & 0x01) != 0) {\n");
            builder.append("    ", this.initializer2, ";\n");
            builder.append("    ", this.scripts, "\n");
            builder.append("  } else {\n");
            builder.append("    ", this.initializer1, ";\n");
            builder.append("  }\n");
            builder.append("}\n");
            return this.source.replaceAll("(void\\s+main\\s*\\(\\)\\s*\\{)(\\s*)", builder.build() + "\n$1$2aw_main_pre();$2$2");
        }

        public String toString() {
            return this.build();
        }
    }

    public static class SourceBuilder {
        private final StringBuffer buffer = new StringBuffer();

        public void append(String value) {
            this.buffer.append(value);
        }

        public void append(String prefix, Collection<String> children, String suffix) {
            for (String content : children) {
                this.buffer.append(prefix);
                this.buffer.append(content);
                this.buffer.append(suffix);
            }
        }

        public String build() {
            return this.buffer.toString();
        }
    }
}

