/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.shader;

import java.util.ArrayList;
import java.util.function.Consumer;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.core.client.shader.ShaderVertexObject;
import moe.plushie.armourers_workshop.core.client.texture.TextureAnimationController;
import moe.plushie.armourers_workshop.core.math.OpenMatrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ShaderVertexGroup {
    public int maxVertexCount;
    private final IRenderType renderType;
    private final TextureAnimationController animationController;
    private final ArrayList<ShaderVertexObject> objects = new ArrayList();

    public ShaderVertexGroup(IRenderType renderType) {
        this.renderType = renderType;
        this.animationController = TextureAnimationController.of(renderType);
    }

    public OpenMatrix4f getTextureMatrix(double animationTime) {
        return this.animationController.getTextureMatrix(animationTime);
    }

    public IRenderType renderType() {
        return this.renderType;
    }

    public int size() {
        return this.objects.size();
    }

    public boolean isEmpty() {
        return this.objects.isEmpty();
    }

    public void add(ShaderVertexObject object) {
        this.objects.add(object);
    }

    public void clear() {
        this.objects.forEach(ShaderVertexObject::release);
        this.objects.clear();
        this.maxVertexCount = 0;
    }

    public void forEach(Consumer<ShaderVertexObject> consumer) {
        this.objects.forEach(consumer);
    }
}

