/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.skinrender.modifier;

import moe.plushie.armourers_workshop.api.armature.IJoint;
import moe.plushie.armourers_workshop.api.armature.IJointTransform;
import moe.plushie.armourers_workshop.api.client.model.IModel;
import moe.plushie.armourers_workshop.api.client.model.IModelPart;
import moe.plushie.armourers_workshop.core.armature.JointModifier;
import moe.plushie.armourers_workshop.core.math.OpenVector3f;

public class DefaultSkirtJointModifier
extends JointModifier {
    @Override
    public IJointTransform apply(IJoint joint, IModel model, IJointTransform transform) {
        IModelPart body = model.partByName("body");
        IModelPart leg1 = model.partByName("left_leg");
        IModelPart leg2 = model.partByName("right_leg");
        if (body == null || leg1 == null || leg2 == null) {
            return transform;
        }
        return poseStack -> {
            float xRot;
            float z = (leg1.pose().z() + leg2.pose().z()) / 2.0f;
            poseStack.translate(body.pose().x(), leg1.pose().y(), z);
            if (body.pose().yRot() != 0.0f) {
                poseStack.rotate(OpenVector3f.YP.rotation(body.pose().yRot()));
            }
            if (Float.compare(xRot = (this.ort(leg1.pose().xRot()) + this.ort(leg2.pose().xRot())) / 2.0f, 0.0f) != 0) {
                poseStack.rotate(OpenVector3f.XP.rotation(xRot));
            }
        };
    }

    private float ort(float q) {
        float pi = (float)Math.PI;
        if (q > pi) {
            return q - pi * 2.0f;
        }
        if (q < -pi) {
            return q + pi * 2.0f;
        }
        return q;
    }
}

