/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.client.texture;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.LinkedHashMap;
import java.util.Map;
import moe.plushie.armourers_workshop.api.client.IRenderType;
import moe.plushie.armourers_workshop.core.client.other.SkinRenderType;
import moe.plushie.armourers_workshop.core.client.other.SmartResourceManager;
import moe.plushie.armourers_workshop.core.client.texture.SmartTextureManager;
import moe.plushie.armourers_workshop.core.client.texture.TextureAnimationController;
import moe.plushie.armourers_workshop.core.data.DataContainer;
import moe.plushie.armourers_workshop.core.skin.geometry.SkinGeometryType;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureData;
import moe.plushie.armourers_workshop.core.skin.texture.SkinTextureProperties;
import moe.plushie.armourers_workshop.core.utils.FileUtils;
import moe.plushie.armourers_workshop.core.utils.OpenRandomSource;
import moe.plushie.armourers_workshop.core.utils.OpenResourceLocation;
import moe.plushie.armourers_workshop.core.utils.ReferenceCounted;
import moe.plushie.armourers_workshop.init.ModConstants;
import moe.plushie.armourers_workshop.utils.RenderSystem;
import org.jetbrains.annotations.Nullable;

public class SmartTexture
extends ReferenceCounted {
    private final OpenResourceLocation location;
    private final SkinTextureProperties properties;
    private final TextureAnimationController animationController;
    private final Map<OpenResourceLocation, ByteBuf> textureBuffers;
    private final Map<SkinGeometryType, IRenderType> bindingRenderTypes = new LinkedHashMap<SkinGeometryType, IRenderType>();

    public SmartTexture(SkinTextureData provider) {
        this.location = ModConstants.key("textures/dynamic/" + OpenRandomSource.nextInt(SmartTexture.class) + ".png");
        this.properties = provider.properties();
        this.textureBuffers = this.resolveTextureBuffers(this.location, provider);
        this.animationController = new TextureAnimationController(provider.animation());
    }

    @Nullable
    public static SmartTexture of(IRenderType renderType) {
        return DataContainer.getOrDefault(renderType, null);
    }

    @Override
    protected void init() {
        RenderSystem.safeCall(() -> {
            this.textureBuffers.forEach(SmartResourceManager.getInstance()::register);
            SmartTextureManager.getInstance().uploadTexture(this);
        });
    }

    @Override
    protected void dispose() {
        RenderSystem.safeCall(() -> {
            SmartTextureManager.getInstance().releaseTexture(this);
            this.textureBuffers.keySet().forEach(SmartResourceManager.getInstance()::unregister);
        });
    }

    public IRenderType renderType(SkinGeometryType type) {
        return this.bindingRenderTypes.computeIfAbsent(type, it -> {
            IRenderType renderType = SkinRenderType.geometryFace(it, this.location, this.properties.isTranslucent(), this.properties.isEmissive());
            DataContainer.set(renderType, this);
            return renderType;
        });
    }

    public OpenResourceLocation location() {
        return this.location;
    }

    public TextureAnimationController animationController() {
        return this.animationController;
    }

    public String toString() {
        return this.location.toString();
    }

    protected void unbind() {
        this.bindingRenderTypes.forEach((key, value) -> DataContainer.set(value, null));
        while (this.refCnt() > 0) {
            this.release();
        }
    }

    private Map<OpenResourceLocation, ByteBuf> resolveTextureBuffers(OpenResourceLocation location, SkinTextureData provider) {
        String path = FileUtils.removeExtension(location.path());
        TextureBufferBuilder builder = new TextureBufferBuilder(provider.properties());
        builder.addData(location, provider);
        for (SkinTextureData variant : provider.variants()) {
            if (variant.properties().isNormal()) {
                builder.addData(location.withPath(path + "_n.png"), variant);
            }
            if (!variant.properties().isSpecular()) continue;
            builder.addData(location.withPath(path + "_s.png"), variant);
        }
        return builder.build();
    }

    private static class TextureBufferBuilder {
        private final Map<OpenResourceLocation, ByteBuf> buffers = new LinkedHashMap<OpenResourceLocation, ByteBuf>();
        private final SkinTextureProperties parentProperties;

        private TextureBufferBuilder(SkinTextureProperties parentProperties) {
            this.parentProperties = parentProperties;
        }

        public void addData(OpenResourceLocation location, SkinTextureData provider) {
            this.buffers.put(location, provider.buffer());
            this.addMeta(location, provider.properties());
        }

        private void addMeta(OpenResourceLocation location, SkinTextureProperties properties) {
            boolean isClampToEdge;
            boolean isBlurFilter = properties.isBlurFilter() || this.parentProperties.isBlurFilter();
            boolean bl = isClampToEdge = properties.isClampToEdge() || this.parentProperties.isClampToEdge();
            if (!isBlurFilter && !isClampToEdge) {
                return;
            }
            String blur = String.valueOf(isBlurFilter);
            String clamp = String.valueOf(isClampToEdge);
            String meta = String.format("{\"texture\":{\"blur\":%s,\"clamp\":%s}}", blur, clamp);
            this.buffers.put(location.withPath(location.path() + ".mcmeta"), Unpooled.wrappedBuffer((byte[])meta.getBytes()));
        }

        public Map<OpenResourceLocation, ByteBuf> build() {
            return this.buffers;
        }
    }
}

