/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.crafting.recipe;

import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.skin.SkinDescriptor;
import moe.plushie.armourers_workshop.core.skin.SkinType;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModItems;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class SkinningRecipe {
    protected SkinType skinType;

    public SkinningRecipe(SkinType skinType) {
        this.skinType = skinType;
    }

    public void apply(IInventory inventory) {
        ItemStack skinStack = ItemStack.field_190927_a;
        ItemStack targetStack = ItemStack.field_190927_a;
        int size = inventory.func_70302_i_();
        for (int i = 1; i < size; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            if (this.isValidSkin(itemStack)) {
                skinStack = itemStack;
                continue;
            }
            if (this.isValidTarget(itemStack)) {
                targetStack = itemStack;
                continue;
            }
            return;
        }
        if (targetStack.func_190926_b() || skinStack.func_190926_b()) {
            return;
        }
        this.shrink(targetStack, skinStack);
    }

    public ItemStack test(IInventory inventory, SkinDescriptor.Options options) {
        ItemStack skinStack = ItemStack.field_190927_a;
        ItemStack targetStack = ItemStack.field_190927_a;
        int size = inventory.func_70302_i_();
        for (int i = 1; i < size; ++i) {
            ItemStack itemStack = inventory.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            if (this.isValidSkin(itemStack)) {
                skinStack = itemStack;
                continue;
            }
            if (this.isValidTarget(itemStack)) {
                targetStack = itemStack;
                continue;
            }
            return ItemStack.field_190927_a;
        }
        if (targetStack.func_190926_b() || skinStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return this.build(targetStack, skinStack, options);
    }

    protected void shrink(ItemStack targetStack, ItemStack skinStack) {
        targetStack.func_190918_g(1);
        skinStack.func_190918_g(1);
    }

    protected ItemStack build(ItemStack targetStack, ItemStack skinStack, SkinDescriptor.Options options) {
        SkinDescriptor skin = ComponentAPI.getOrDefault(skinStack, (IDataComponentType)ModDataComponents.SKIN.get(), SkinDescriptor.EMPTY);
        ItemStack newItemStack = targetStack.func_77946_l();
        newItemStack.func_190920_e(1);
        ComponentAPI.set(newItemStack, (IDataComponentType)ModDataComponents.SKIN.get(), skin.withOptions(options));
        return newItemStack;
    }

    protected boolean isValidSkin(ItemStack itemStack) {
        return ModItems.SKIN.get() == itemStack.func_77973_b() && SkinDescriptor.of(itemStack).type() == this.skinType;
    }

    protected boolean isValidTarget(ItemStack itemStack) {
        return ModItems.SKIN.get() != itemStack.func_77973_b();
    }
}

