/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.data.cache;

import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import moe.plushie.armourers_workshop.core.data.cache.AutoreleasePool;
import org.apache.commons.lang3.tuple.Pair;

public class CacheQueue<K, V> {
    private long nextCheckTime;
    private final long expiredTime;
    private final Consumer<V> releaseHandler;
    private final ArrayList<Pair<K, V>> queuing = new ArrayList();
    private final HashMap<K, Entry<V>> values = new HashMap();
    private final AutoreleasePool<?> autoreleasePool;

    public CacheQueue(Duration expiredTime) {
        this(expiredTime, null);
    }

    public CacheQueue(Duration expiredTime, Consumer<V> releaseHandler) {
        this.expiredTime = expiredTime.toMillis();
        this.releaseHandler = releaseHandler;
        this.autoreleasePool = new AutoreleasePool<1>(() -> new AutoreleasePool.Lifecycle(){

            @Override
            public void begin() {
            }

            @Override
            public void end() {
                CacheQueue.this.drain(System.currentTimeMillis());
            }
        });
    }

    public void clearAll() {
        if (this.releaseHandler != null) {
            for (Entry<V> entry : this.values.values()) {
                this.releaseHandler.accept(((Entry)entry).value);
            }
        }
        this.values.clear();
    }

    public V remove(K key) {
        Entry<V> entry = this.values.remove(key);
        if (entry != null) {
            return (V)((Entry)entry).value;
        }
        return null;
    }

    public V put(K key, V value) {
        Entry<V> entry = new Entry<V>(value);
        ((Entry)entry).expiredTime = System.currentTimeMillis() + this.expiredTime;
        Entry<V> oldEntry = this.values.put(key, entry);
        if (oldEntry != null) {
            return (V)((Entry)oldEntry).value;
        }
        return null;
    }

    public V get(K key) {
        long time = System.currentTimeMillis();
        Entry<V> entry = this.values.get(key);
        if (entry != null) {
            ((Entry)entry).expiredTime = time + this.expiredTime;
            return (V)((Entry)entry).value;
        }
        return null;
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> provider) {
        V entry = this.get(key);
        if (entry != null) {
            return entry;
        }
        entry = provider.apply(key);
        this.put(key, entry);
        return entry;
    }

    private void drain(long time) {
        if (this.nextCheckTime > time) {
            return;
        }
        this.nextCheckTime = time + this.expiredTime;
        for (Map.Entry<K, Entry<V>> entry : this.values.entrySet()) {
            Entry<V> value = entry.getValue();
            if (((Entry)value).expiredTime > time) continue;
            this.queuing.add(Pair.of(entry.getKey(), (Object)((Entry)value).value));
        }
        for (Pair pair : this.queuing) {
            this.values.remove(pair.getKey());
            if (this.releaseHandler == null) continue;
            this.releaseHandler.accept(pair.getValue());
        }
        this.queuing.clear();
    }

    public static class Entry<V> {
        private long expiredTime;
        private final V value;

        public Entry(V value) {
            this.value = value;
        }
    }
}

