/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.holiday;

import java.util.Calendar;
import moe.plushie.armourers_workshop.api.core.IDataCodec;
import moe.plushie.armourers_workshop.init.ModHolidays;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;

public class Holiday {
    public static final IDataCodec<Holiday> CODEC = IDataCodec.STRING.xmap(ModHolidays::byName, Holiday::name);
    protected final String name;
    protected final Calendar startDate;
    protected final Calendar endDate;
    protected IHandler handler;
    protected int tintColor1 = -13421773;
    protected int tintColor2 = -1;
    protected boolean enabled = true;

    public Holiday(String name, Calendar startDate, Calendar endDate) {
        this.name = name;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public String name() {
        return this.name;
    }

    public Calendar startDate() {
        return this.startDate;
    }

    public Calendar endDate() {
        return this.endDate;
    }

    public IHandler handler() {
        return this.handler;
    }

    public void setHandler(IHandler handler) {
        this.handler = handler;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isHolidayActive() {
        if (this.enabled) {
            Calendar current = Calendar.getInstance();
            return current.after(this.startDate) & current.before(this.endDate);
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Holiday)) {
            return false;
        }
        Holiday that = (Holiday)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static interface IHandler {
        public ItemStack getGift(PlayerEntity var1);

        default public int backgroundColor() {
            return 0xFFFFFF;
        }

        default public int foregroundColor() {
            return 0x333333;
        }
    }
}

