/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.network.IClientPacketHandler;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.nbt.CompoundTag.OptionalAPI;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.entity.Entity.PropertyProvider;
import moe.plushie.armourers_workshop.core.client.animation.AnimationManager;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.core.utils.TickUtils;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.BlockPos;

public class UpdateAnimationPacket
extends CustomPacket {
    private final Mode mode;
    private final CompoundNBT value;

    public UpdateAnimationPacket(Mode mode, CompoundNBT value) {
        this.mode = mode;
        this.value = value;
    }

    public UpdateAnimationPacket(IFriendlyByteBuf buffer) {
        this.mode = buffer.readEnum(Mode.class);
        this.value = buffer.readNbt();
    }

    public static UpdateAnimationPacket play(Selector selector, String name, CompoundNBT properties) {
        CompoundNBT tag = selector.save();
        tag.func_74778_a("name", name);
        tag.func_218657_a("properties", (INBT)properties);
        return new UpdateAnimationPacket(Mode.PLAY, tag);
    }

    public static UpdateAnimationPacket stop(Selector selector, String name) {
        CompoundNBT tag = selector.save();
        tag.func_74778_a("name", name);
        return new UpdateAnimationPacket(Mode.STOP, tag);
    }

    public static UpdateAnimationPacket rewrite(Selector selector, String from, String to) {
        CompoundNBT tag = selector.save();
        tag.func_74778_a("from", from);
        tag.func_74778_a("to", to);
        return new UpdateAnimationPacket(Mode.MAPPING, tag);
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum(this.mode);
        buffer.writeNbt(this.value);
    }

    @Override
    public void accept(IClientPacketHandler packetHandler, PlayerEntity player) {
        switch (this.mode.ordinal()) {
            case 0: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String name = OptionalAPI.getOptionalString(this.value, "name").orElse("");
                CompoundNBT properties = OptionalAPI.getOptionalCompound(this.value, "properties").orElseGet(CompoundNBT::new);
                ModLog.debug("play animation {}", this.value);
                animationManager.play(name, TickUtils.animationTicks(), properties);
                break;
            }
            case 1: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String name = OptionalAPI.getOptionalString(this.value, "name").orElse("");
                ModLog.debug("stop animation {}", this.value);
                animationManager.stop(name);
                break;
            }
            case 2: {
                AnimationManager animationManager = this.getTargetRenderData(player);
                if (animationManager == null) break;
                String from = OptionalAPI.getOptionalString(this.value, "from").orElse("");
                String to = OptionalAPI.getOptionalString(this.value, "to").orElse("");
                ModLog.debug("rewrite animation {} to {}", from, to);
                animationManager.map(from, to);
                break;
            }
        }
    }

    private AnimationManager getTargetRenderData(PlayerEntity player) {
        if (this.value.func_74764_b("entity")) {
            Integer entityId = OptionalAPI.getOptionalInt(this.value, "entity").orElse(0);
            return AnimationManager.of(PropertyProvider.getLevel((Entity)player).func_73045_a(entityId.intValue()));
        }
        if (this.value.func_74764_b("block")) {
            BlockPos blockPos = BlockPos.func_218283_e((long)OptionalAPI.getOptionalLong(this.value, "block").orElse(0L));
            return AnimationManager.of(PropertyProvider.getLevel((Entity)player).func_175625_s(blockPos));
        }
        return null;
    }

    public static enum Mode {
        PLAY,
        STOP,
        MAPPING,
        MODERATOR;

    }

    public static class Selector {
        private final int id;
        private final BlockPos pos;

        public Selector(Entity entity) {
            this.id = entity.func_145782_y();
            this.pos = null;
        }

        public Selector(BlockPos blockPos) {
            this.id = -1;
            this.pos = blockPos;
        }

        public CompoundNBT save() {
            CompoundNBT tag = new CompoundNBT();
            if (this.pos != null) {
                tag.func_74772_a("block", this.pos.func_218275_a());
            } else {
                tag.func_74768_a("entity", this.id);
            }
            return tag;
        }
    }
}

