/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.network;

import moe.plushie.armourers_workshop.api.common.IConfigurableTool;
import moe.plushie.armourers_workshop.api.core.IDataComponentType;
import moe.plushie.armourers_workshop.api.network.IFriendlyByteBuf;
import moe.plushie.armourers_workshop.api.network.IServerPacketHandler;
import moe.plushie.armourers_workshop.compatibility.extensions.net.minecraft.world.item.ItemStack.ComponentAPI;
import moe.plushie.armourers_workshop.core.network.CustomPacket;
import moe.plushie.armourers_workshop.init.ModDataComponents;
import moe.plushie.armourers_workshop.init.ModLog;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;

public class UpdateConfigurableToolPacket
extends CustomPacket {
    private final Hand hand;
    private final ItemStack itemStack;

    public UpdateConfigurableToolPacket(IFriendlyByteBuf buffer) {
        this.hand = buffer.readEnum(Hand.class);
        this.itemStack = buffer.readItem();
    }

    public UpdateConfigurableToolPacket(Hand hand, ItemStack itemStack) {
        this.hand = hand;
        this.itemStack = itemStack;
    }

    @Override
    public void encode(IFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum<?>)this.hand);
        buffer.writeItem(this.itemStack);
    }

    @Override
    public void accept(IServerPacketHandler packetHandler, ServerPlayerEntity player) {
        ItemStack oldItemStack = player.func_184586_b(this.hand);
        if (!(oldItemStack.func_77973_b() instanceof IConfigurableTool)) {
            this.abort((PlayerEntity)player, "update", "tried change unsupported item type.");
            return;
        }
        if (!oldItemStack.func_77973_b().equals(this.itemStack.func_77973_b())) {
            this.abort((PlayerEntity)player, "update", "tried change item type.");
            return;
        }
        ItemStack newItemStack = oldItemStack.func_77946_l();
        this.copyTo(this.itemStack, newItemStack, (IDataComponentType)ModDataComponents.TOOL_OPTIONS.get());
        this.copyTo(this.itemStack, newItemStack, (IDataComponentType)ModDataComponents.TOOL_COLOR.get());
        player.func_184611_a(this.hand, newItemStack);
    }

    private <T> void copyTo(ItemStack fromItemStack, ItemStack toItemStack, IDataComponentType<T> key) {
        T value = ComponentAPI.get(fromItemStack, key);
        ComponentAPI.set(toItemStack, key, value);
    }

    private void abort(PlayerEntity player, String op, String reason) {
        ModLog.info("abort {} request of the '{}', reason: '{}', from: '{}', to: '{}'", op, player.func_195047_I_(), reason, player.func_184586_b(this.hand), this.itemStack);
    }
}

