/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.permission;

import java.util.Collection;
import java.util.HashMap;
import moe.plushie.armourers_workshop.api.core.IRegistryHolder;
import moe.plushie.armourers_workshop.api.core.IResourceLocation;
import moe.plushie.armourers_workshop.api.permission.IPermissionContext;
import moe.plushie.armourers_workshop.api.permission.IPermissionNode;
import moe.plushie.armourers_workshop.core.permission.PlayerPermissionContext;
import moe.plushie.armourers_workshop.init.ModConfig;
import moe.plushie.armourers_workshop.init.platform.BuilderManager;
import net.minecraft.entity.player.PlayerEntity;
import org.jetbrains.annotations.Nullable;

public abstract class Permission {
    protected final String name;
    protected final HashMap<IResourceLocation, IPermissionNode> nodes = new HashMap();

    public Permission(String name) {
        this.name = name;
    }

    protected void add(IRegistryHolder<?> object) {
        IResourceLocation registryName = object.registryName();
        IPermissionNode node = this.makeNode(registryName.path() + "." + this.name);
        this.nodes.put(registryName, node);
    }

    protected IPermissionNode get(IResourceLocation registryName) {
        return this.nodes.get(registryName);
    }

    protected boolean eval(IPermissionNode node, PlayerEntity player, @Nullable PlayerPermissionContext context) {
        if (ModConfig.Common.enablePermissionCheck) {
            return node.resolve(player, (IPermissionContext)context);
        }
        return true;
    }

    private IPermissionNode makeNode(String path) {
        return (IPermissionNode)BuilderManager.getInstance().createPermissionBuilder().level(0).build(path);
    }

    public String name() {
        return this.name;
    }

    public Collection<IPermissionNode> nodes() {
        return this.nodes.values();
    }
}

