/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.armourers_workshop.core.skin.molang.runtime;

import java.util.ArrayList;
import java.util.List;
import moe.plushie.armourers_workshop.core.skin.molang.core.Expression;
import moe.plushie.armourers_workshop.core.skin.molang.core.Visitor;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.ArrayAccess;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Binary;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Call;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Compound;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Return;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.StructAccess;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Ternary;
import moe.plushie.armourers_workshop.core.skin.molang.core.ast.Unary;

public abstract class Transformer
implements Visitor {
    public Expression transform(Expression expression) {
        return expression.visit(this);
    }

    public List<Expression> transform(List<Expression> expressions) {
        ArrayList<Expression> results = new ArrayList<Expression>();
        for (Expression expression : expressions) {
            results.add(this.transform(expression));
        }
        return results;
    }

    @Override
    public Expression visitStructAccess(StructAccess expression) {
        return new StructAccess(this.transform(expression.receiver()), expression.name());
    }

    @Override
    public Expression visitArrayAccess(ArrayAccess expression) {
        return new ArrayAccess(this.transform(expression.receiver()), this.transform(expression.index()));
    }

    @Override
    public Expression visitCall(Call expression) {
        return new Call(this.transform(expression.receiver()), this.transform(expression.arguments()));
    }

    @Override
    public Expression visitUnary(Unary expression) {
        return new Unary(expression.op(), this.transform(expression.value()));
    }

    @Override
    public Expression visitBinary(Binary expression) {
        return new Binary(expression.op(), this.transform(expression.left()), this.transform(expression.right()));
    }

    @Override
    public Expression visitTernary(Ternary expression) {
        return new Ternary(this.transform(expression.condition()), this.transform(expression.trueValue()), this.transform(expression.falseValue()));
    }

    @Override
    public Expression visitCompound(Compound expression) {
        return new Compound(this.transform(expression.expressions()));
    }

    @Override
    public Expression visitReturn(Return expression) {
        return new Return(this.transform(expression.value()));
    }
}

